/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.universe;

import barsuift.simLife.Randomizer;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.universe.UniverseState;
import barsuift.simLife.universe.UniverseStateFactory;
import java.util.Set;
import junit.framework.TestCase;

public class UniverseStateFactoryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateRandomUniverseState() {
        UniverseStateFactory factory = new UniverseStateFactory();
        int nbTrees = Randomizer.randomBetween((int)1, (int)4);
        UniverseState universeState = factory.createRandomUniverseState(nbTrees);
        UniverseStateFactoryTest.assertNotNull((Object)universeState.getEnvironment());
        Set trees = universeState.getTrees();
        for (TreeState treeState : trees) {
            int nbBranches = treeState.getBranches().size();
            UniverseStateFactoryTest.assertTrue((nbBranches >= 30 ? 1 : 0) != 0);
            UniverseStateFactoryTest.assertTrue((nbBranches <= 50 ? 1 : 0) != 0);
            float height = treeState.getHeight();
            UniverseStateFactoryTest.assertTrue((height >= 3.0f ? 1 : 0) != 0);
            UniverseStateFactoryTest.assertTrue((height <= 5.0f ? 1 : 0) != 0);
        }
        Long id1 = universeState.getId();
        UniverseStateFactoryTest.assertNotNull((Object)id1);
        UniverseStateFactoryTest.assertTrue((id1 > 0L ? 1 : 0) != 0);
        universeState = factory.createRandomUniverseState(nbTrees);
        Long id2 = universeState.getId();
        UniverseStateFactoryTest.assertEquals((long)(id1 + 1L), (long)id2);
    }
}

