/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.Randomizer;
import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.tree.TreeStateFactory;
import barsuift.simLife.tree.TreeTrunkState;
import java.math.BigDecimal;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;

public class TreeStateFactoryTest
extends TestCase {
    private TreeStateFactory factory;

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new TreeStateFactory();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.factory = null;
    }

    public void testCreateRandomTreeState() {
        Point3d translationVector = new Point3d(Math.random(), Math.random(), Math.random());
        int nbBranches = Randomizer.randomBetween((int)40, (int)60);
        float height = Randomizer.randomBetween((int)8, (int)12);
        TreeState treeState = this.factory.createRandomTreeState(translationVector, nbBranches, height);
        List branches = treeState.getBranches();
        TreeStateFactoryTest.assertEquals((int)nbBranches, (int)branches.size());
        TreeStateFactoryTest.assertEquals((Object)Float.valueOf(height), (Object)Float.valueOf(treeState.getHeight()));
        TreeTrunkState trunkState = treeState.getTrunkState();
        TreeStateFactoryTest.assertEquals((Object)Float.valueOf(height / 8.0f), (Object)Float.valueOf(trunkState.getRadius()));
        TreeStateFactoryTest.assertNotNull((Object)treeState.getTree3DState());
        Long id1 = treeState.getId();
        TreeStateFactoryTest.assertNotNull((Object)id1);
        TreeStateFactoryTest.assertTrue((id1 > 0L ? 1 : 0) != 0);
        TreeStateFactoryTest.assertTrue((treeState.getAge() >= 0 ? 1 : 0) != 0);
        TreeStateFactoryTest.assertTrue((treeState.getAge() <= 100 ? 1 : 0) != 0);
        TreeStateFactoryTest.assertTrue((treeState.getEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeStateFactoryTest.assertTrue((treeState.getEnergy().compareTo(new BigDecimal(100)) <= 0 ? 1 : 0) != 0);
        treeState = this.factory.createRandomTreeState(translationVector, nbBranches, height);
        Long id2 = treeState.getId();
        TreeStateFactoryTest.assertEquals((long)(id1 + 1L), (long)id2);
    }

    public void testComputeBranchTranslationVector() {
        float treeRadius = 6.0f;
        float treeHeight = 8.0f;
        Vector3d translationVector = this.factory.computeBranchTranslationVector(treeRadius, treeHeight);
        PointTestHelper.assertPointIsWithinBounds((Point3d)new Point3d((Tuple3d)translationVector), (Point3d)new Point3d(-6.0, 8.0, -6.0), (Point3d)new Point3d(6.0, 8.0, 6.0));
        treeRadius = 0.2f;
        treeHeight = 15.0f;
        translationVector = this.factory.computeBranchTranslationVector(treeRadius, treeHeight);
        PointTestHelper.assertPointIsWithinBounds((Point3d)new Point3d((Tuple3d)translationVector), (Point3d)new Point3d(-0.2, 15.0, -0.2), (Point3d)new Point3d(0.2, 15.0, 0.2));
    }

    public void testComputeBranchEndPoint() {
        double treeHeight = 12.0;
        boolean goingToPositiveX = true;
        boolean goingToPositiveZ = false;
        Point3d branchEndPoint = this.factory.computeBranchEndPoint(treeHeight, goingToPositiveX, goingToPositiveZ);
        PointTestHelper.assertPointIsWithinBounds((Point3d)branchEndPoint, (Point3d)new Point3d(0.0, 0.0, 0.0), (Point3d)new Point3d(6.0, 12.0, -6.0));
        treeHeight = 2.4;
        goingToPositiveX = false;
        goingToPositiveZ = true;
        branchEndPoint = this.factory.computeBranchEndPoint(treeHeight, goingToPositiveX, goingToPositiveZ);
        PointTestHelper.assertPointIsWithinBounds((Point3d)branchEndPoint, (Point3d)new Point3d(0.0, 0.0, 0.0), (Point3d)new Point3d(-1.2, 2.4, 1.2));
    }
}

