/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.j3d.Point3dState;
import barsuift.simLife.j3d.helper.PointTestHelper;
import barsuift.simLife.tree.TreeBranchPartState;
import barsuift.simLife.tree.TreeBranchPartStateFactory;
import barsuift.simLife.tree.TreeLeafState;
import java.math.BigDecimal;
import java.util.List;
import javax.vecmath.Point3d;
import junit.framework.TestCase;

public class TreeBranchPartStateFactoryTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateRandomBranchPartState() {
        TreeBranchPartStateFactory factory = new TreeBranchPartStateFactory();
        Point3d branchPartEndPoint = new Point3d(Math.random(), Math.random(), Math.random());
        TreeBranchPartState branchPartState = factory.createRandomBranchPartState(branchPartEndPoint);
        TreeBranchPartStateFactoryTest.assertNotNull((Object)branchPartState.getBranchPart3DState());
        List leaveStates = branchPartState.getLeaveStates();
        int nbLeaves = leaveStates.size();
        TreeBranchPartStateFactoryTest.assertTrue((nbLeaves >= 2 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((nbLeaves <= 4 ? 1 : 0) != 0);
        for (int index = 0; index < nbLeaves; ++index) {
            TreeLeafState leafState = (TreeLeafState)leaveStates.get(index);
            Point3dState leafAttachPoint = leafState.getLeaf3DState().getLeafAttachPoint();
            PointTestHelper.assertPointIsWithinBounds((Point3d)leafAttachPoint.toPointValue(), (Point3d)new Point3d(0.0, 0.0, 0.0), (Point3d)branchPartEndPoint);
        }
        Long id1 = branchPartState.getId();
        TreeBranchPartStateFactoryTest.assertNotNull((Object)id1);
        TreeBranchPartStateFactoryTest.assertTrue((id1 > 0L ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getAge() >= 0 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getAge() <= 100 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getEnergy().compareTo(new BigDecimal(100)) <= 0 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getFreeEnergy().compareTo(new BigDecimal(0)) >= 0 ? 1 : 0) != 0);
        TreeBranchPartStateFactoryTest.assertTrue((branchPartState.getFreeEnergy().compareTo(new BigDecimal(50)) <= 0 ? 1 : 0) != 0);
        branchPartState = factory.createRandomBranchPartState(branchPartEndPoint);
        Long id2 = branchPartState.getId();
        TreeBranchPartStateFactoryTest.assertEquals((long)(id1 + 1L), (long)id2);
    }
}

