/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.tree;

import barsuift.simLife.CoreDataCreatorForTests;
import barsuift.simLife.Percent;
import barsuift.simLife.environment.MockSun;
import barsuift.simLife.tree.BasicTree;
import barsuift.simLife.tree.TreeState;
import barsuift.simLife.universe.MockUniverse;
import barsuift.simLife.universe.Universe;
import junit.framework.TestCase;

public class BasicTreeTest
extends TestCase {
    private MockUniverse universe;
    private TreeState treeState;
    private BasicTree tree;

    protected void setUp() throws Exception {
        super.setUp();
        this.universe = new MockUniverse();
        this.treeState = CoreDataCreatorForTests.createSpecificTreeState();
        this.tree = new BasicTree((Universe)this.universe, this.treeState);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.universe = null;
        this.treeState = null;
        this.tree = null;
    }

    public void testBasicTree() {
        BasicTreeTest.assertEquals((int)this.treeState.getBranches().size(), (int)this.tree.getNbBranches());
        try {
            new BasicTree(null, this.treeState);
            BasicTreeTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BasicTree((Universe)this.universe, null);
            BasicTreeTest.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetState() {
        BasicTreeTest.assertEquals((Object)this.treeState, (Object)this.tree.getState());
    }

    public void testSpendTime() {
        ((MockSun)this.universe.getEnvironment().getSun()).setLuminosity(new Percent(70));
        this.tree.spendTime();
        BasicTreeTest.assertEquals((int)16, (int)this.tree.getAge());
        BasicTreeTest.assertEquals((int)40, (int)this.tree.getNbBranches());
        BasicTreeTest.assertEquals((double)2041.168, (double)this.tree.getEnergy().doubleValue(), (double)1.0E-4);
    }
}

