/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.panel;

import barsuift.simLife.j2d.DateDisplay;
import barsuift.simLife.j2d.action.SpeedAction;
import barsuift.simLife.j2d.button.OneStepButton;
import barsuift.simLife.j2d.button.StartButton;
import barsuift.simLife.j2d.button.StopButton;
import barsuift.simLife.process.MainSynchronizer;
import barsuift.simLife.process.Speed;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.UniverseContext;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TimeControllerPanel
extends JPanel {
    private static final long serialVersionUID = 5530349468986336456L;
    private final DateDisplay dateDisplay;

    public TimeControllerPanel(UniverseContext universeContext) {
        this.setLayout(new BoxLayout(this, 3));
        this.setMaximumSize(new Dimension(220, 100));
        this.setAlignmentX(0.5f);
        Universe universe = universeContext.getUniverse();
        this.dateDisplay = new DateDisplay(universe.getDate());
        this.dateDisplay.setAlignmentX(0.5f);
        this.add(this.dateDisplay);
        MainSynchronizer synchronizer = universeContext.getSynchronizer();
        JPanel speedPanel = this.createSpeedPanel(synchronizer);
        this.add(speedPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.setAlignmentX(0.5f);
        buttonPanel.add(new OneStepButton(synchronizer));
        buttonPanel.add(new StartButton(synchronizer));
        buttonPanel.add(new StopButton(synchronizer));
        this.add(buttonPanel);
        Border blacklineBorder = BorderFactory.createLineBorder(Color.black);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(blacklineBorder, "Time Control");
        this.setBorder(titledBorder);
    }

    private JPanel createSpeedPanel(MainSynchronizer synchronizer) {
        JPanel speedPanel = new JPanel();
        speedPanel.setLayout(new BoxLayout(speedPanel, 2));
        SpeedAction actionNormalSpeed = new SpeedAction(synchronizer, "Normal", "Normal speed", 49, Speed.NORMAL.name());
        JRadioButton normalSpeed = new JRadioButton(actionNormalSpeed);
        SpeedAction actionFastSpeed = new SpeedAction(synchronizer, "Fast", "Fast speed (about 5 times faster))", 50, Speed.FAST.name());
        JRadioButton fastSpeed = new JRadioButton(actionFastSpeed);
        SpeedAction actionVeryFastSpeed = new SpeedAction(synchronizer, "Very fast", "Very fast speed (about 20 times faster)", 51, Speed.VERY_FAST.name());
        JRadioButton veryFastSpeed = new JRadioButton(actionVeryFastSpeed);
        Speed speed = synchronizer.getSpeed();
        normalSpeed.setSelected(speed == Speed.NORMAL);
        fastSpeed.setSelected(speed == Speed.FAST);
        veryFastSpeed.setSelected(speed == Speed.VERY_FAST);
        ButtonGroup speedSwitch = new ButtonGroup();
        speedSwitch.add(normalSpeed);
        speedSwitch.add(fastSpeed);
        speedSwitch.add(veryFastSpeed);
        speedPanel.add(new JLabel("Speed"));
        speedPanel.add(normalSpeed);
        speedPanel.add(fastSpeed);
        speedPanel.add(veryFastSpeed);
        return speedPanel;
    }
}

