/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.panel;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.Sun;
import java.awt.Dimension;
import java.math.BigDecimal;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SunZenithPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -6102868842517781193L;
    private static final int ANGLE_MIN = 0;
    private static final int ANGLE_MAX = 100;
    private final Sun sun;
    private final JLabel sliderLabel;
    private final JSlider zenithSlider;

    public SunZenithPanel(Sun sun) {
        this.sun = sun;
        this.setLayout(new BoxLayout(this, 3));
        this.sliderLabel = this.createLabel();
        this.zenithSlider = this.createSlider();
        this.add(this.sliderLabel);
        this.add(this.zenithSlider);
    }

    private JSlider createSlider() {
        JSlider zenithSlider = new JSlider(1, 0, 100, PercentHelper.getIntValue((BigDecimal)this.sun.getZenithAngle()));
        zenithSlider.setMaximumSize(new Dimension(80, 180));
        zenithSlider.addChangeListener(this);
        zenithSlider.setMajorTickSpacing(20);
        zenithSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("Horizon"));
        labelTable.put(new Integer(100), new JLabel("Zenith"));
        zenithSlider.setLabelTable(labelTable);
        zenithSlider.setPaintLabels(true);
        return zenithSlider;
    }

    private JLabel createLabel() {
        JLabel sliderLabel = new JLabel("Zenith angle", 0);
        sliderLabel.setAlignmentX(0.5f);
        return sliderLabel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int zenithAngle = source.getValue();
        this.sun.setZenithAngle(PercentHelper.getDecimalValue((int)zenithAngle));
    }

    protected JLabel getLabel() {
        return this.sliderLabel;
    }

    protected JSlider getSlider() {
        return this.zenithSlider;
    }
}

