/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.panel;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.SunUpdateCode;
import barsuift.simLife.j3d.environment.Sun3D;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import java.math.BigDecimal;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class SunColorPanel
extends JPanel
implements Subscriber {
    private static final long serialVersionUID = -6493265804580797791L;
    private static final int FACTOR_MIN = 0;
    private static final int FACTOR_MAX = 100;
    private final Sun3D sun3D;
    private final JLabel sliderLabel;
    private final JSlider slider;

    public SunColorPanel(Sun3D sun3D) {
        this.sun3D = sun3D;
        sun3D.addSubscriber((Subscriber)this);
        this.setLayout(new BoxLayout(this, 3));
        this.sliderLabel = this.createLabel();
        this.slider = this.createSlider();
        this.add(this.sliderLabel);
        this.add(this.slider);
    }

    private JSlider createSlider() {
        JSlider slider = new JSlider(0, 0, 100, PercentHelper.getIntValue((BigDecimal)this.sun3D.getWhiteFactor()));
        slider.setMajorTickSpacing(20);
        slider.setMinorTickSpacing(5);
        slider.setPaintTicks(true);
        slider.setEnabled(false);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("Red"));
        labelTable.put(new Integer(100), new JLabel("White"));
        slider.setLabelTable(labelTable);
        slider.setPaintLabels(true);
        return slider;
    }

    private JLabel createLabel() {
        JLabel sliderLabel = new JLabel("Sun color", 0);
        sliderLabel.setAlignmentX(0.5f);
        return sliderLabel;
    }

    protected JLabel getLabel() {
        return this.sliderLabel;
    }

    protected JSlider getSlider() {
        return this.slider;
    }

    public void update(Publisher publisher, Object arg) {
        if (arg == SunUpdateCode.color) {
            this.slider.setValue(PercentHelper.getIntValue((BigDecimal)this.sun3D.getWhiteFactor()));
        }
    }
}

