/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.panel;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.Sun;
import barsuift.simLife.environment.SunUpdateCode;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import java.math.BigDecimal;
import java.text.MessageFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SunBrightnessPanel
extends JPanel
implements ChangeListener,
Subscriber {
    private static final long serialVersionUID = -6102868842517781193L;
    private static final int LUMINOSITY_MIN = 0;
    private static final int LUMINOSITY_MAX = 100;
    private static final MessageFormat LABEL_FORMAT = new MessageFormat("Sun brightness ({0})");
    private final Sun sun;
    private final JLabel sliderLabel;
    private final JSlider brightnessSlider;

    public SunBrightnessPanel(Sun sun) {
        this.sun = sun;
        sun.addSubscriber((Subscriber)this);
        this.setLayout(new BoxLayout(this, 3));
        this.sliderLabel = this.createLabel();
        this.brightnessSlider = this.createSlider();
        this.add(this.sliderLabel);
        this.add(this.brightnessSlider);
    }

    private JSlider createSlider() {
        JSlider brightnessSlider = new JSlider(0, 0, 100, PercentHelper.getIntValue((BigDecimal)this.sun.getBrightness()));
        brightnessSlider.addChangeListener(this);
        brightnessSlider.setMajorTickSpacing(20);
        brightnessSlider.setMinorTickSpacing(5);
        brightnessSlider.setPaintTicks(true);
        brightnessSlider.setPaintLabels(true);
        return brightnessSlider;
    }

    private JLabel createLabel() {
        JLabel sliderLabel = new JLabel(this.createBrightnessLabelText(), 0);
        sliderLabel.setAlignmentX(0.5f);
        sliderLabel.setMinimumSize(sliderLabel.getPreferredSize());
        return sliderLabel;
    }

    private String createBrightnessLabelText() {
        return LABEL_FORMAT.format(new Object[]{PercentHelper.getStringValue((BigDecimal)this.sun.getBrightness())});
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int brightness = source.getValue();
        this.sun.setBrightness(PercentHelper.getDecimalValue((int)brightness));
    }

    public void update(Publisher publisher, Object arg) {
        if (arg == SunUpdateCode.brightness) {
            this.sliderLabel.setText(this.createBrightnessLabelText());
            this.brightnessSlider.setValue(PercentHelper.getIntValue((BigDecimal)this.sun.getBrightness()));
        }
    }

    protected JLabel getLabel() {
        return this.sliderLabel;
    }

    protected JSlider getSlider() {
        return this.brightnessSlider;
    }
}

