/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.action.menu;

import barsuift.simLife.Application;
import barsuift.simLife.ApplicationUpdateCode;
import barsuift.simLife.j2d.menu.Accelerators;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.process.MainSynchronizer;
import barsuift.simLife.universe.SaveException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class SaveAsAction
extends AbstractAction
implements Subscriber {
    private static final long serialVersionUID = -2391532464769897167L;
    private final Application application;

    public SaveAsAction(Application application) {
        this.application = application;
        application.addSubscriber(this);
        this.putValue("Name", "Save As ...");
        this.putValue("ShortDescription", "Save the current universe in a new file");
        this.putValue("MnemonicKey", 65);
        this.putValue("AcceleratorKey", Accelerators.SAVE_AS);
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean wasRunning = this.stopApp();
        this.saveAs();
        if (wasRunning) {
            MainSynchronizer synchronizer = this.application.getUniverseContext().getSynchronizer();
            synchronizer.start();
        }
    }

    private boolean stopApp() {
        MainSynchronizer synchronizer = this.application.getUniverseContext().getSynchronizer();
        if (synchronizer.isRunning()) {
            synchronizer.stop();
            return true;
        }
        return false;
    }

    private void saveAs() {
        try {
            this.application.saveUniverseAs();
        }
        catch (SaveException se) {
            System.out.println("Unable to save the universe to given file because " + se.getMessage());
        }
    }

    public void update(Publisher publisher, Object arg) {
        if (arg == ApplicationUpdateCode.NEW_EMPTY || arg == ApplicationUpdateCode.NEW_RANDOM || arg == ApplicationUpdateCode.OPEN) {
            this.setEnabled(true);
        }
    }
}

