/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.action.menu;

import barsuift.simLife.Application;
import barsuift.simLife.j2d.menu.Accelerators;
import barsuift.simLife.process.MainSynchronizer;
import barsuift.simLife.universe.OpenException;
import barsuift.simLife.universe.UniverseContext;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class OpenAction
extends AbstractAction {
    private static final long serialVersionUID = -7706268023944038274L;
    private final Application application;

    public OpenAction(Application application) {
        this.application = application;
        this.putValue("Name", "Open");
        this.putValue("ShortDescription", "Open another universe");
        this.putValue("MnemonicKey", 79);
        this.putValue("AcceleratorKey", Accelerators.OPEN);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopApp();
        this.open();
    }

    private void stopApp() {
        MainSynchronizer synchronizer;
        UniverseContext universeContext = this.application.getUniverseContext();
        if (universeContext != null && (synchronizer = universeContext.getSynchronizer()).isRunning()) {
            synchronizer.stop();
        }
    }

    private void open() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                this.application.openUniverse(file);
            }
            catch (OpenException oe) {
                System.out.println("Unable to open the given file : " + file.getAbsolutePath() + " because " + oe.getMessage());
            }
        }
    }
}

