/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.action.menu;

import barsuift.simLife.Application;
import barsuift.simLife.ApplicationUpdateCode;
import barsuift.simLife.j2d.menu.Accelerators;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.universe.UniverseContext;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class AxisAction
extends AbstractAction
implements Subscriber {
    private static final long serialVersionUID = 649806431886707462L;
    private UniverseContext universeContext;
    private boolean axisShowing;

    public AxisAction(Application application) {
        this.universeContext = application.getUniverseContext();
        application.addSubscriber(this);
        this.axisShowing = this.universeContext == null ? false : this.universeContext.isAxisShowing();
        this.putValue("MnemonicKey", 65);
        this.putValue("AcceleratorKey", Accelerators.AXIS);
        this.updateState(this.axisShowing);
        this.setEnabled(false);
    }

    private void updateState(boolean axisShowing) {
        this.axisShowing = axisShowing;
        if (axisShowing) {
            this.putValue("Name", "Do not show axis");
            this.putValue("ShortDescription", "Hide the axis");
        } else {
            this.putValue("Name", "Show axis");
            this.putValue("ShortDescription", "Show the axis");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateState(!this.axisShowing);
        this.universeContext.setAxisShowing(this.axisShowing);
    }

    public void update(Publisher publisher, Object arg) {
        if (arg == ApplicationUpdateCode.OPEN || arg == ApplicationUpdateCode.NEW_EMPTY || arg == ApplicationUpdateCode.NEW_RANDOM) {
            this.setEnabled(true);
            this.universeContext = ((Application)publisher).getUniverseContext();
            this.updateState(((Application)publisher).getUniverseContext().isAxisShowing());
        }
    }
}

