/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.ApplicationUpdateCode;
import barsuift.simLife.j2d.MainWindow;
import barsuift.simLife.message.BasicPublisher;
import barsuift.simLife.message.Publisher;
import barsuift.simLife.message.Subscriber;
import barsuift.simLife.universe.BasicUniverseContextFactory;
import barsuift.simLife.universe.OpenException;
import barsuift.simLife.universe.SaveException;
import barsuift.simLife.universe.UniverseContext;
import barsuift.simLife.universe.UniverseContextIO;
import java.io.File;
import javax.swing.JFileChooser;

public class Application
implements Publisher {
    private File currentSaveFile;
    private UniverseContext currentUniverseContext;
    private MainWindow window;
    private final Publisher publisher = new BasicPublisher((Publisher)this);

    public Application() {
        this.window = new MainWindow();
        this.window.createMenuBar(this);
        this.window.setVisible(true);
    }

    public UniverseContext createEmptyUniverse() {
        BasicUniverseContextFactory factory = new BasicUniverseContextFactory();
        this.currentUniverseContext = factory.createEmpty();
        this.currentSaveFile = null;
        this.window.changeUniverse(this.currentUniverseContext);
        this.setChanged();
        this.notifySubscribers((Object)ApplicationUpdateCode.NEW_EMPTY);
        return this.currentUniverseContext;
    }

    public UniverseContext createRandomUniverse() {
        BasicUniverseContextFactory factory = new BasicUniverseContextFactory();
        this.currentUniverseContext = factory.createRandom();
        this.currentSaveFile = null;
        this.window.changeUniverse(this.currentUniverseContext);
        this.setChanged();
        this.notifySubscribers((Object)ApplicationUpdateCode.NEW_RANDOM);
        return this.currentUniverseContext;
    }

    public UniverseContext openUniverse(File saveFile) throws OpenException {
        UniverseContextIO envIO = new UniverseContextIO(saveFile);
        this.currentUniverseContext = envIO.read();
        this.window.changeUniverse(this.currentUniverseContext);
        this.currentSaveFile = saveFile;
        this.setChanged();
        this.notifySubscribers((Object)ApplicationUpdateCode.OPEN);
        return this.currentUniverseContext;
    }

    public void saveUniverse() throws SaveException {
        if (this.currentSaveFile == null) {
            throw new IllegalStateException("No current save file");
        }
        if (this.currentUniverseContext == null) {
            throw new IllegalStateException("No current universe context to save");
        }
        UniverseContextIO envIO = new UniverseContextIO(this.currentSaveFile);
        envIO.write(this.currentUniverseContext);
        this.setChanged();
        this.notifySubscribers((Object)ApplicationUpdateCode.SAVE);
    }

    public void saveUniverseAs() throws SaveException {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this.window);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.saveUniverseAs(file);
        }
    }

    public void saveUniverseAs(File saveFile) throws SaveException {
        if (this.currentUniverseContext == null) {
            throw new IllegalStateException("No current universe context to save");
        }
        UniverseContextIO envIO = new UniverseContextIO(saveFile);
        envIO.write(this.currentUniverseContext);
        this.currentSaveFile = saveFile;
        this.setChanged();
        this.notifySubscribers((Object)ApplicationUpdateCode.SAVE_AS);
    }

    public UniverseContext getUniverseContext() {
        return this.currentUniverseContext;
    }

    public MainWindow getMainWindow() {
        return this.window;
    }

    public void addSubscriber(Subscriber subscriber) {
        this.publisher.addSubscriber(subscriber);
    }

    public void deleteSubscriber(Subscriber subscriber) {
        this.publisher.deleteSubscriber(subscriber);
    }

    public void notifySubscribers() {
        this.publisher.notifySubscribers();
    }

    public void notifySubscribers(Object arg) {
        this.publisher.notifySubscribers(arg);
    }

    public void deleteSubscribers() {
        this.publisher.deleteSubscribers();
    }

    public boolean hasChanged() {
        return this.publisher.hasChanged();
    }

    public int countSubscribers() {
        return this.publisher.countSubscribers();
    }

    public void setChanged() {
        this.publisher.setChanged();
    }

    public void clearChanged() {
        this.publisher.clearChanged();
    }
}

