/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.Application;
import barsuift.simLife.PercentHelper;
import barsuift.simLife.universe.BasicUniverseContextFactory;
import barsuift.simLife.universe.OpenException;
import barsuift.simLife.universe.SaveException;
import barsuift.simLife.universe.Universe;
import barsuift.simLife.universe.UniverseContext;
import barsuift.simLife.universe.UniverseContextIO;
import java.io.File;
import junit.framework.TestCase;

public class ApplicationTest
extends TestCase {
    private Application application;
    private File saveFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.application = new Application();
        this.saveFile = new File("target/test/testUniverse.xml");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.application = null;
        this.saveFile.delete();
        this.saveFile = null;
    }

    public void testSaveUniverse() throws SaveException {
        try {
            this.application.saveUniverse();
            ApplicationTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        UniverseContext universeContext = this.application.createEmptyUniverse();
        Universe universe = universeContext.getUniverse();
        try {
            this.application.saveUniverse();
            ApplicationTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.application.saveUniverseAs(this.saveFile);
        universe.getEnvironment().getSun().setBrightness(PercentHelper.getDecimalValue((int)13));
        this.application.saveUniverse();
        this.application.createEmptyUniverse();
        try {
            this.application.saveUniverse();
            ApplicationTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testOpen() throws OpenException, SaveException {
        BasicUniverseContextFactory factory = new BasicUniverseContextFactory();
        UniverseContext universeContext = factory.createRandom();
        UniverseContextIO io = new UniverseContextIO(this.saveFile);
        io.write(universeContext);
        UniverseContext universeContext2 = this.application.openUniverse(this.saveFile);
        ApplicationTest.assertEquals((Object)universeContext.getState(), (Object)universeContext2.getState());
    }
}

