/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.panel;

import barsuift.simLife.j2d.TimerDisplay;
import barsuift.simLife.j2d.action.SpeedAction;
import barsuift.simLife.j2d.menu.Accelerators;
import barsuift.simLife.time.UniverseTimeController;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TimeControllerPanel
extends JPanel {
    private static final long serialVersionUID = 5530349468986336456L;
    private final UniverseTimeController controller;
    private final TimerDisplay timerDisplay;
    private final JButton oneStepButton;
    private final JButton startButton;
    private final JButton pauseButton;
    private final JPanel buttonPanel;

    public TimeControllerPanel(UniverseTimeController timeController) {
        this.controller = timeController;
        this.setLayout(new BoxLayout(this, 3));
        this.setMaximumSize(new Dimension(220, 100));
        this.setAlignmentX(0.5f);
        this.timerDisplay = this.createTimerDisplay();
        this.timerDisplay.setAlignmentX(0.5f);
        this.add(this.timerDisplay);
        JPanel speedPanel = this.createSpeedPanel(timeController);
        this.add(speedPanel);
        this.oneStepButton = this.createOneStepButton();
        this.startButton = this.createStartButton();
        this.pauseButton = this.createPauseButton();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setAlignmentX(0.5f);
        this.buttonPanel.add(this.oneStepButton);
        this.buttonPanel.add(this.startButton);
        this.buttonPanel.add(this.pauseButton);
        this.add(this.buttonPanel);
        Border blacklineBorder = BorderFactory.createLineBorder(Color.black);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(blacklineBorder, "Time Control");
        this.setBorder(titledBorder);
    }

    private JPanel createSpeedPanel(UniverseTimeController timeController) {
        JPanel speedPanel = new JPanel();
        speedPanel.setLayout(new BoxLayout(speedPanel, 2));
        SpeedAction action1 = new SpeedAction(timeController, "1", "1 cycle / sec", 49, Accelerators.SPEED_1, "1");
        JRadioButton speed1 = new JRadioButton(action1);
        speed1.setSelected(true);
        SpeedAction action10 = new SpeedAction(timeController, "10", "10 cycles / sec", 50, Accelerators.SPEED_10, "10");
        JRadioButton speed10 = new JRadioButton(action10);
        ButtonGroup speedSwitch = new ButtonGroup();
        speedSwitch.add(speed1);
        speedSwitch.add(speed10);
        speedPanel.add(new JLabel("Speed"));
        speedPanel.add(speed1);
        speedPanel.add(speed10);
        return speedPanel;
    }

    private TimerDisplay createTimerDisplay() {
        return new TimerDisplay(this.controller.getTimeCounter());
    }

    private JButton createOneStepButton() {
        JButton button = new JButton("ONE STEP");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeControllerPanel.this.controller.oneStep();
            }
        });
        return button;
    }

    private JButton createStartButton() {
        JButton button = new JButton("START");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeControllerPanel.this.oneStepButton.setEnabled(false);
                TimeControllerPanel.this.startButton.setVisible(false);
                TimeControllerPanel.this.controller.start();
                TimeControllerPanel.this.pauseButton.setVisible(true);
            }
        });
        return button;
    }

    private JButton createPauseButton() {
        JButton button = new JButton("PAUSE");
        button.setVisible(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeControllerPanel.this.pauseButton.setVisible(false);
                TimeControllerPanel.this.controller.pause();
                TimeControllerPanel.this.oneStepButton.setEnabled(true);
                TimeControllerPanel.this.startButton.setVisible(true);
            }
        });
        return button;
    }
}

