/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.panel;

import barsuift.simLife.PercentHelper;
import barsuift.simLife.environment.Sun;
import barsuift.simLife.environment.SunUpdateCode;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SunLuminosityPanel
extends JPanel
implements ChangeListener,
Observer {
    private static final long serialVersionUID = -6102868842517781193L;
    private static final int LUMINOSITY_MIN = 0;
    private static final int LUMINOSITY_MAX = 100;
    private static final MessageFormat LABEL_FORMAT = new MessageFormat("Sun luminosity ({0})");
    private final Sun sun;
    private final JLabel sliderLabel;
    private final JSlider luminositySlider;

    public SunLuminosityPanel(Sun sun) {
        this.sun = sun;
        sun.addObserver((Observer)this);
        this.setLayout(new BoxLayout(this, 3));
        this.sliderLabel = this.createLabel();
        this.luminositySlider = this.createSlider();
        this.add(this.sliderLabel);
        this.add(this.luminositySlider);
    }

    private JSlider createSlider() {
        JSlider luminositySlider = new JSlider(0, 0, 100, PercentHelper.getIntValue((BigDecimal)this.sun.getLuminosity()));
        luminositySlider.addChangeListener(this);
        luminositySlider.setMajorTickSpacing(20);
        luminositySlider.setMinorTickSpacing(5);
        luminositySlider.setPaintTicks(true);
        luminositySlider.setPaintLabels(true);
        return luminositySlider;
    }

    private JLabel createLabel() {
        JLabel sliderLabel = new JLabel(this.createLuminosityLabelText(), 0);
        sliderLabel.setAlignmentX(0.5f);
        sliderLabel.setMinimumSize(sliderLabel.getPreferredSize());
        return sliderLabel;
    }

    private String createLuminosityLabelText() {
        return LABEL_FORMAT.format(new Object[]{PercentHelper.getStringValue((BigDecimal)this.sun.getLuminosity())});
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int luminosity = source.getValue();
        this.sun.setLuminosity(PercentHelper.getDecimalValue((int)luminosity));
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == SunUpdateCode.luminosity) {
            this.sliderLabel.setText(this.createLuminosityLabelText());
            this.luminositySlider.setValue(PercentHelper.getIntValue((BigDecimal)this.sun.getLuminosity()));
        }
    }

    protected JLabel getLabel() {
        return this.sliderLabel;
    }

    protected JSlider getSlider() {
        return this.luminositySlider;
    }
}

