/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.action.menu;

import barsuift.simLife.Application;
import barsuift.simLife.ApplicationUpdateCode;
import barsuift.simLife.j2d.menu.Accelerators;
import barsuift.simLife.universe.SaveException;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;

public class SaveAsAction
extends AbstractAction
implements Observer {
    private static final long serialVersionUID = -2391532464769897167L;
    private final Application application;

    public SaveAsAction(Application application) {
        this.application = application;
        application.addObserver(this);
        this.putValue("Name", "Save As ...");
        this.putValue("ShortDescription", "Save the current universe in a new file");
        this.putValue("MnemonicKey", 65);
        this.putValue("AcceleratorKey", Accelerators.SAVE_AS);
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.application.saveUniverseAs();
        }
        catch (SaveException se) {
            System.out.println("Unable to save the universe to given file because " + se.getMessage());
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == ApplicationUpdateCode.NEW_EMPTY || arg == ApplicationUpdateCode.NEW_RANDOM || arg == ApplicationUpdateCode.OPEN) {
            this.setEnabled(true);
        }
    }
}

