/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.action.menu;

import barsuift.simLife.Application;
import barsuift.simLife.ApplicationUpdateCode;
import barsuift.simLife.j2d.menu.Accelerators;
import barsuift.simLife.universe.SaveException;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;

public class SaveAction
extends AbstractAction
implements Observer {
    private static final long serialVersionUID = 8223229157394283604L;
    private final Application application;
    private boolean isAbleToSave;

    public SaveAction(Application application) {
        this.application = application;
        application.addObserver(this);
        this.isAbleToSave = false;
        this.putValue("Name", "Save");
        this.putValue("ShortDescription", "Save the current universe");
        this.putValue("MnemonicKey", 83);
        this.putValue("AcceleratorKey", Accelerators.SAVE);
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isAbleToSave) {
            try {
                this.application.saveUniverse();
            }
            catch (SaveException se) {
                System.out.println("Unable to save the universe to the current save file because " + se.getMessage());
            }
        } else {
            try {
                this.application.saveUniverseAs();
            }
            catch (SaveException se) {
                System.out.println("Unable to save the universe to given file because " + se.getMessage());
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == ApplicationUpdateCode.SAVE_AS || arg == ApplicationUpdateCode.OPEN) {
            this.setEnabled(true);
            this.isAbleToSave = true;
        }
        if (arg == ApplicationUpdateCode.NEW_EMPTY || arg == ApplicationUpdateCode.NEW_RANDOM) {
            this.setEnabled(true);
            this.isAbleToSave = false;
        }
    }
}

