/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.action.menu;

import barsuift.simLife.Application;
import barsuift.simLife.ApplicationUpdateCode;
import barsuift.simLife.j2d.menu.Accelerators;
import barsuift.simLife.universe.UniverseContext;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;

public class FpsAction
extends AbstractAction
implements Observer {
    private static final long serialVersionUID = 8709944906687074411L;
    private UniverseContext universeContext;
    private boolean fpsShowing;

    public FpsAction(Application application) {
        this.universeContext = application.getUniverseContext();
        application.addObserver(this);
        this.fpsShowing = this.universeContext == null ? false : this.universeContext.isFpsShowing();
        this.putValue("MnemonicKey", 70);
        this.putValue("AcceleratorKey", Accelerators.FPS);
        this.updateState(this.fpsShowing);
        this.setEnabled(false);
    }

    private void updateState(boolean fpsShowing) {
        this.fpsShowing = fpsShowing;
        if (fpsShowing) {
            this.putValue("Name", "Do not show FPS");
            this.putValue("ShortDescription", "Hide the FPS (Frame Per Second)");
        } else {
            this.putValue("Name", "Show FPS");
            this.putValue("ShortDescription", "Show the FPS (Frame Per Second)");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateState(!this.fpsShowing);
        this.universeContext.setFpsShowing(this.fpsShowing);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == ApplicationUpdateCode.OPEN || arg == ApplicationUpdateCode.NEW_EMPTY || arg == ApplicationUpdateCode.NEW_RANDOM) {
            this.setEnabled(true);
            this.universeContext = ((Application)o).getUniverseContext();
            this.updateState(((Application)o).getUniverseContext().isFpsShowing());
        }
    }
}

