/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.panel;

import barsuift.simLife.j3d.Axis3DGroup;
import barsuift.simLife.j3d.universe.Universe3D;
import barsuift.simLife.j3d.util.TransformerHelper;
import com.sun.j3d.utils.behaviors.keyboard.KeyNavigatorBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class Universe3DPanel
extends JPanel {
    private static final long serialVersionUID = -9023573589569686409L;
    private SimpleUniverse simpleU;
    private TransformGroup viewTransform;
    private BranchGroup root;
    private final Axis3DGroup axisGroup = new Axis3DGroup();

    public Universe3DPanel(Universe3D universe3D) {
        Canvas3D canvas3D = this.createGlobalGraphics();
        this.simpleU = new SimpleUniverse(canvas3D);
        this.viewTransform = this.simpleU.getViewingPlatform().getViewPlatformTransform();
        this.moveView();
        this.root = new BranchGroup();
        this.root.setCapability(14);
        this.root.setCapability(13);
        this.addNavigators(this.root);
        this.root.addChild((Node)universe3D.getUniverseRoot());
        this.root.compile();
        this.simpleU.addBranchGraph(this.root);
    }

    public void addChild(Shape3D child) {
        BranchGroup group = new BranchGroup();
        group.setCapability(17);
        group.addChild((Node)child);
        this.addChild(group);
    }

    public void addChild(BranchGroup child) {
        this.root.addChild((Node)child);
    }

    public void removeChild(BranchGroup child) {
        this.root.removeChild((Node)child);
    }

    public void removeChild(Shape3D child) {
        BranchGroup childParent = (BranchGroup)child.getParent();
        this.root.removeChild((Node)childParent);
        childParent.removeChild((Node)child);
    }

    private void addNavigators(BranchGroup root) {
        KeyNavigatorBehavior navigator = this.createKeyboardNavigator(this.viewTransform);
        root.addChild((Node)navigator);
        MouseTranslate mouseTranslateNavigator = this.createMouseTranslateNavigator(this.viewTransform);
        root.addChild((Node)mouseTranslateNavigator);
        MouseZoom mouseZoomNavigator = this.createMouseZoomNavigator(this.viewTransform);
        root.addChild((Node)mouseZoomNavigator);
    }

    private Canvas3D createGlobalGraphics() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(config);
        this.add("Center", (Component)canvas3D);
        return canvas3D;
    }

    private void moveView() {
        Transform3D t3d = TransformerHelper.getTranslationTransform3D((Vector3d)new Vector3d(4.0, 2.0, 20.0));
        this.viewTransform.setTransform(t3d);
    }

    public KeyNavigatorBehavior createKeyboardNavigator(TransformGroup viewTransform) {
        KeyNavigatorBehavior keyNavigator = new KeyNavigatorBehavior(viewTransform);
        keyNavigator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        return keyNavigator;
    }

    private MouseTranslate createMouseTranslateNavigator(TransformGroup viewTransform) {
        MouseTranslate mouseTranslateNavigator = new MouseTranslate(2);
        mouseTranslateNavigator.setTransformGroup(viewTransform);
        mouseTranslateNavigator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        return mouseTranslateNavigator;
    }

    private MouseZoom createMouseZoomNavigator(TransformGroup viewTransform) {
        MouseZoom mouseZoomNavigator = new MouseZoom(2);
        mouseZoomNavigator.setTransformGroup(viewTransform);
        mouseZoomNavigator.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000.0));
        return mouseZoomNavigator;
    }

    public void setAxis() {
        this.addChild((BranchGroup)this.axisGroup);
    }

    public void unsetAxis() {
        this.removeChild((BranchGroup)this.axisGroup);
    }
}

