/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.j2d.MainWindow;
import barsuift.simLife.universe.BasicUniverseFactory;
import barsuift.simLife.universe.BasicUniverseIO;
import barsuift.simLife.universe.OpenException;
import barsuift.simLife.universe.SaveException;
import barsuift.simLife.universe.Universe;
import java.io.File;

public class Application {
    private File currentSaveFile;
    private Universe currentUniverse;
    private MainWindow window = new MainWindow(this);

    public Application() {
        this.window.setVisible(true);
    }

    public Universe createEmptyUniverse() {
        Universe universe;
        BasicUniverseFactory factory = new BasicUniverseFactory();
        this.currentUniverse = universe = factory.createEmpty();
        this.currentSaveFile = null;
        this.window.changeUniverse(this.currentUniverse);
        return this.currentUniverse;
    }

    public Universe createRandomUniverse() {
        Universe universe;
        BasicUniverseFactory factory = new BasicUniverseFactory();
        this.currentUniverse = universe = factory.createRandom();
        this.currentSaveFile = null;
        this.window.changeUniverse(this.currentUniverse);
        return this.currentUniverse;
    }

    public Universe openUniverse(File saveFile) throws OpenException {
        Universe universe;
        BasicUniverseIO envIO = new BasicUniverseIO(saveFile);
        this.currentUniverse = universe = envIO.read();
        this.window.changeUniverse(this.currentUniverse);
        this.currentSaveFile = saveFile;
        return this.currentUniverse;
    }

    public void saveUniverse() throws SaveException {
        if (this.currentSaveFile == null) {
            throw new IllegalStateException("No current save file");
        }
        if (this.currentUniverse == null) {
            throw new IllegalStateException("No current universe to save");
        }
        BasicUniverseIO envIO = new BasicUniverseIO(this.currentSaveFile);
        envIO.write(this.currentUniverse);
    }

    public void saveUniverseAs(File saveFile) throws SaveException {
        if (this.currentUniverse == null) {
            throw new IllegalStateException("No current universe to save");
        }
        BasicUniverseIO envIO = new BasicUniverseIO(saveFile);
        envIO.write(this.currentUniverse);
        this.currentSaveFile = saveFile;
    }
}

