/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.panel;

import barsuift.simLife.Percent;
import barsuift.simLife.environment.Sun;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SunRisePanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -6102868842517781193L;
    private static final int ANGLE_MIN = 0;
    private static final int ANGLE_MAX = 100;
    private final Sun sun;
    private final JLabel sliderLabel;
    private final JSlider riseSlider;

    public SunRisePanel(Sun sun) {
        this.sun = sun;
        this.setLayout(new BoxLayout(this, 3));
        this.sliderLabel = this.createLabel();
        this.riseSlider = this.createSlider();
        this.add(this.sliderLabel);
        this.add(this.riseSlider);
    }

    private JSlider createSlider() {
        JSlider riseSlider = new JSlider(0, 0, 100, this.sun.getRiseAngle().getIntValue());
        riseSlider.addChangeListener(this);
        riseSlider.setMajorTickSpacing(50);
        riseSlider.setMinorTickSpacing(10);
        riseSlider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("Sunrise"));
        labelTable.put(new Integer(50), new JLabel("Zenith"));
        labelTable.put(new Integer(100), new JLabel("Sunset"));
        riseSlider.setLabelTable(labelTable);
        riseSlider.setPaintLabels(true);
        return riseSlider;
    }

    private JLabel createLabel() {
        JLabel sliderLabel = new JLabel("Rise angle", 0);
        sliderLabel.setAlignmentX(0.5f);
        return sliderLabel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int riseAngle = source.getValue();
        this.sun.setRiseAngle(new Percent(riseAngle));
    }

    protected JLabel getLabel() {
        return this.sliderLabel;
    }

    protected JSlider getSlider() {
        return this.riseSlider;
    }
}

