/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife.j2d.action;

import barsuift.simLife.Application;
import barsuift.simLife.universe.SaveException;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

public class SaveAsAction
extends AbstractAction {
    private static final long serialVersionUID = -2391532464769897167L;
    private final Application application;

    public SaveAsAction(Application application) {
        this.application = application;
        this.putValue("Name", "Save As ...");
        this.putValue("ShortDescription", "Save the current universe in a new file");
        this.putValue("MnemonicKey", 65);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 3));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                this.application.saveUniverseAs(file);
            }
            catch (SaveException se) {
                System.out.println("Unable to save the universe to the given file : " + file.getAbsolutePath() + " because " + se.getMessage());
            }
        }
    }
}

