/*
 * Decompiled with CFR 0.152.
 */
package barsuift.simLife;

import barsuift.simLife.Application;
import barsuift.simLife.Percent;
import barsuift.simLife.universe.BasicUniverseFactory;
import barsuift.simLife.universe.BasicUniverseIO;
import barsuift.simLife.universe.OpenException;
import barsuift.simLife.universe.SaveException;
import barsuift.simLife.universe.Universe;
import java.io.File;
import junit.framework.TestCase;

public class ApplicationTest
extends TestCase {
    private Application application;
    private File saveFile;

    protected void setUp() throws Exception {
        super.setUp();
        this.application = new Application();
        this.saveFile = new File("target/test/testUniverse.xml");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.application = null;
        this.saveFile.delete();
        this.saveFile = null;
    }

    public void testSaveUniverse() throws SaveException {
        try {
            this.application.saveUniverse();
            ApplicationTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        Universe universe = this.application.createEmptyUniverse();
        try {
            this.application.saveUniverse();
            ApplicationTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.application.saveUniverseAs(this.saveFile);
        universe.getEnvironment().getSun().setLuminosity(new Percent(13));
        this.application.saveUniverse();
        this.application.createEmptyUniverse();
        try {
            this.application.saveUniverse();
            ApplicationTest.fail((String)"Should throw an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testOpen() throws OpenException, SaveException {
        BasicUniverseFactory factory = new BasicUniverseFactory();
        Universe universe = factory.createRandom();
        BasicUniverseIO io = new BasicUniverseIO(this.saveFile);
        io.write(universe);
        Universe universe2 = this.application.openUniverse(this.saveFile);
        ApplicationTest.assertEquals((Object)universe, (Object)universe2);
    }
}

