/*
 * Decompiled with CFR 0.152.
 */
package ba.sake.hepek.core;

import classycle.Analyser;
import classycle.graph.AtomicVertex;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassycleDependencyUtils {
    private ClassycleDependencyUtils() {
        throw new UnsupportedOperationException("Can't instantiate ClassycleDependencyUtils.");
    }

    public static Map<AtomicVertex, Set<AtomicVertex>> reverseDependencies(List<File> list, boolean bl) {
        AtomicVertex[] atomicVertexArray;
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            atomicVertexArray = list.get(i);
            stringArray[i] = atomicVertexArray.getAbsolutePath();
        }
        Analyser analyser = new Analyser(stringArray);
        atomicVertexArray = analyser.getClassGraph();
        if (bl) {
            return ClassycleDependencyUtils.getDirectRevDeps(atomicVertexArray);
        }
        return ClassycleDependencyUtils.getTransitiveRevDeps(atomicVertexArray);
    }

    static Map<AtomicVertex, Set<AtomicVertex>> getDirectRevDeps(AtomicVertex[] atomicVertexArray) {
        HashMap<AtomicVertex, Set<AtomicVertex>> hashMap = new HashMap<AtomicVertex, Set<AtomicVertex>>(atomicVertexArray.length);
        for (AtomicVertex atomicVertex : atomicVertexArray) {
            int n = atomicVertex.getNumberOfIncomingArcs();
            HashSet<AtomicVertex> hashSet = new HashSet<AtomicVertex>(n);
            for (int i = 0; i < n; ++i) {
                AtomicVertex atomicVertex2 = (AtomicVertex)atomicVertex.getTailVertex(i);
                hashSet.add(atomicVertex2);
            }
            hashMap.put(atomicVertex, hashSet);
        }
        return hashMap;
    }

    static Map<AtomicVertex, Set<AtomicVertex>> getTransitiveRevDeps(AtomicVertex[] atomicVertexArray) {
        Map<AtomicVertex, Set<AtomicVertex>> map = ClassycleDependencyUtils.getDirectRevDeps(atomicVertexArray);
        HashMap<AtomicVertex, Set<AtomicVertex>> hashMap = new HashMap<AtomicVertex, Set<AtomicVertex>>(map.keySet().size());
        for (AtomicVertex atomicVertex : map.keySet()) {
            Set<AtomicVertex> set = ClassycleDependencyUtils.getTransitiveRevDepsForClass(atomicVertex, map, new HashSet<AtomicVertex>());
            hashMap.put(atomicVertex, set);
        }
        return hashMap;
    }

    static Set<AtomicVertex> getTransitiveRevDepsForClass(AtomicVertex atomicVertex, Map<AtomicVertex, Set<AtomicVertex>> map, Set<AtomicVertex> set) {
        Set<AtomicVertex> set2 = map.get(atomicVertex);
        HashSet<AtomicVertex> hashSet = new HashSet<AtomicVertex>(set);
        set.addAll(set2);
        HashSet<AtomicVertex> hashSet2 = new HashSet<AtomicVertex>();
        for (AtomicVertex atomicVertex2 : set2) {
            if (hashSet.contains(atomicVertex2)) continue;
            Set<AtomicVertex> set3 = ClassycleDependencyUtils.getTransitiveRevDepsForClass(atomicVertex2, map, set);
            hashSet2.addAll(set3);
        }
        set2.addAll(hashSet2);
        Iterator<AtomicVertex> iterator = set2.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(atomicVertex)) continue;
            iterator.remove();
        }
        return set2;
    }
}

