/*
 * Decompiled with CFR 0.152.
 */
package classycle.util;

import classycle.util.OrStringPattern;
import classycle.util.StringPattern;
import java.util.StringTokenizer;

public final class WildCardPattern
implements StringPattern {
    private static final String WILD_CARD = "*";
    private final String pattern;
    private final String[] constantParts;
    private final boolean startsWithAnything;
    private final boolean endsWithAnything;

    public WildCardPattern(String string) {
        this.pattern = string;
        this.startsWithAnything = string.startsWith(WILD_CARD);
        this.endsWithAnything = string.endsWith(WILD_CARD);
        StringTokenizer stringTokenizer = new StringTokenizer(string, WILD_CARD);
        this.constantParts = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < this.constantParts.length; ++i) {
            this.constantParts[i] = stringTokenizer.nextToken();
        }
    }

    @Override
    public boolean matches(String string) {
        return string == null ? false : this.matches(string, 0, 0);
    }

    private boolean matches(String string, int n, int n2) {
        boolean bl = true;
        if (n2 < this.constantParts.length) {
            int n3;
            String string2 = this.constantParts[n2];
            do {
                if ((n3 = string.indexOf(string2, n)) >= 0 && (n != 0 || this.startsWithAnything || n3 <= 0)) continue;
                bl = false;
                break;
            } while (!(bl = this.matches(string, n = n3 + string2.length(), n2 + 1)));
        } else {
            bl = bl && (this.endsWithAnything || n == string.length());
        }
        return bl;
    }

    public String toString() {
        return this.pattern;
    }

    public static StringPattern createFromsPatterns(String string, String string2) {
        if (string2.indexOf(WILD_CARD) >= 0) {
            throw new IllegalArgumentException("No wild card '*' are allowed as delimiters: " + string2);
        }
        OrStringPattern orStringPattern = new OrStringPattern(new StringPattern[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            orStringPattern.appendPattern(new WildCardPattern(stringTokenizer.nextToken().trim()));
        }
        return orStringPattern;
    }
}

