/*
 * Decompiled with CFR 0.152.
 */
package classycle.renderer;

import classycle.graph.GraphAttributes;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import classycle.renderer.AbstractStrongComponentRenderer;
import java.text.MessageFormat;

public class XMLStrongComponentRenderer
extends AbstractStrongComponentRenderer {
    private final int minimumSize;

    public XMLStrongComponentRenderer(int n) {
        this.minimumSize = n;
    }

    protected String getBestFragmentersElementName() {
        return "bestFragmenters";
    }

    protected String getCenterNodesElementName() {
        return "centerClasses";
    }

    protected String getNodeElementName() {
        return "classRef";
    }

    private MessageFormat getNodeElementTemplate() {
        return new MessageFormat("        <" + this.getNodeElementName() + " name=\"{0}\"/>\n");
    }

    private MessageFormat getNodeElementTemplateWithEccentricity() {
        return new MessageFormat("        <" + this.getNodeElementName() + " name=\"{0}\" eccentricity=\"{1}\" maximumFragmentSize=\"{2}\"/>\n");
    }

    protected String getNodesElementName() {
        return "classes";
    }

    protected String getStrongComponentElementName() {
        return "cycle";
    }

    private MessageFormat getStrongComponentElementTemplate() {
        return new MessageFormat("    <" + this.getStrongComponentElementName() + " name=\"{0}\" size=\"{1}\" longestWalk=\"{2}\" girth=\"{3}\" radius=\"{4}\" diameter=\"{5}\" bestFragmentSize=\"{6}\">\n");
    }

    @Override
    public String render(StrongComponent strongComponent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (strongComponent.getNumberOfVertices() >= this.minimumSize) {
            String[] stringArray = new String[7];
            stringArray[0] = XMLStrongComponentRenderer.createName(strongComponent);
            stringArray[1] = Integer.toString(strongComponent.getNumberOfVertices());
            stringArray[2] = Integer.toString(strongComponent.getLongestWalk());
            GraphAttributes graphAttributes = (GraphAttributes)strongComponent.getAttributes();
            stringArray[3] = Integer.toString(graphAttributes.getGirth());
            stringArray[4] = Integer.toString(graphAttributes.getRadius());
            stringArray[5] = Integer.toString(graphAttributes.getDiameter());
            stringArray[6] = Integer.toString(graphAttributes.getBestFragmentSize());
            stringBuilder.append(this.getStrongComponentElementTemplate().format(stringArray));
            this.renderClasses(strongComponent, stringBuilder);
            this.renderVertices(graphAttributes.getCenterVertices(), stringBuilder, this.getCenterNodesElementName());
            this.renderVertices(graphAttributes.getBestFragmenters(), stringBuilder, this.getBestFragmentersElementName());
            stringBuilder.append("    </").append(this.getStrongComponentElementName()).append(">\n");
        }
        return stringBuilder.toString();
    }

    private void renderClasses(StrongComponent strongComponent, StringBuilder stringBuilder) {
        stringBuilder.append("      <").append(this.getNodesElementName()).append(">\n");
        int[] nArray = ((GraphAttributes)strongComponent.getAttributes()).getEccentricities();
        int[] nArray2 = ((GraphAttributes)strongComponent.getAttributes()).getMaximumFragmentSizes();
        String[] stringArray = new String[3];
        MessageFormat messageFormat = this.getNodeElementTemplateWithEccentricity();
        int n = strongComponent.getNumberOfVertices();
        for (int i = 0; i < n; ++i) {
            stringArray[0] = ((NameAttributes)strongComponent.getVertex(i).getAttributes()).getName();
            stringArray[1] = Integer.toString(nArray[i]);
            stringArray[2] = Integer.toString(nArray2[i]);
            stringBuilder.append(messageFormat.format(stringArray));
        }
        stringBuilder.append("      </").append(this.getNodesElementName()).append(">\n");
    }

    private void renderVertices(Vertex[] vertexArray, StringBuilder stringBuilder, String string) {
        stringBuilder.append("      <").append(string).append(">\n");
        String[] stringArray = new String[1];
        MessageFormat messageFormat = this.getNodeElementTemplate();
        for (int i = 0; i < vertexArray.length; ++i) {
            stringArray[0] = ((NameAttributes)vertexArray[i].getAttributes()).getName();
            stringBuilder.append(messageFormat.format(stringArray));
        }
        stringBuilder.append("      </").append(string).append(">\n");
    }
}

