/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.Attributes;
import java.util.Vector;

public class Vertex {
    private final Vector<Vertex> heads = new Vector();
    private final Vector<Vertex> tails = new Vector();
    private final Attributes attributes;
    private boolean visited;

    public Vertex(Attributes attributes) {
        this.attributes = attributes;
    }

    public void addIncomingArcTo(Vertex vertex) {
        if (!this.tails.contains(vertex)) {
            this.tails.addElement(vertex);
            vertex.addOutgoingArcTo(this);
        }
    }

    public void addOutgoingArcTo(Vertex vertex) {
        if (!this.heads.contains(vertex)) {
            this.heads.addElement(vertex);
            vertex.addIncomingArcTo(this);
        }
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Vertex getHeadVertex(int n) {
        return this.heads.elementAt(n);
    }

    public int getNumberOfIncomingArcs() {
        return this.tails.size();
    }

    public int getNumberOfOutgoingArcs() {
        return this.heads.size();
    }

    public Vertex getTailVertex(int n) {
        return this.tails.elementAt(n);
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void reset() {
        this.visited = false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getAttributes() == null ? super.toString() : this.getAttributes().toString()).append(": ").append(this.getNumberOfIncomingArcs()).append(" incoming arc(s), ").append(this.getNumberOfOutgoingArcs()).append(" outgoing arc(s).");
        return stringBuilder.toString();
    }

    public void visit() {
        this.visited = true;
    }
}

