/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.GraphProcessor;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class StrongComponentProcessor
extends GraphProcessor {
    private final boolean calculateAttributes;
    private int counter;
    private final Stack<AtomicVertex> vertexStack = new Stack();
    private final Vector<StrongComponent> strongComponents = new Vector();
    private final Hashtable<AtomicVertex, StrongComponent> vertexToComponents = new Hashtable();
    private StrongComponent[] graph;

    public StrongComponentProcessor(boolean bl) {
        this.calculateAttributes = bl;
    }

    private AtomicVertex castAsAtomicVertex(Vertex vertex) {
        if (vertex instanceof AtomicVertex) {
            return (AtomicVertex)vertex;
        }
        throw new IllegalArgumentException(vertex + " is not an instance of AtomicVertex");
    }

    @Override
    protected void finishProcessing(Vertex[] vertexArray) {
        this.graph = new StrongComponent[this.strongComponents.size()];
        for (int i = 0; i < this.graph.length; ++i) {
            this.graph[i] = this.strongComponents.elementAt(i);
            if (!this.calculateAttributes) continue;
            this.graph[i].calculateAttributes();
        }
        Enumeration<AtomicVertex> enumeration = this.vertexToComponents.keys();
        while (enumeration.hasMoreElements()) {
            AtomicVertex atomicVertex = enumeration.nextElement();
            StrongComponent strongComponent = this.vertexToComponents.get(atomicVertex);
            int n = atomicVertex.getNumberOfOutgoingArcs();
            for (int i = 0; i < n; ++i) {
                StrongComponent strongComponent2;
                AtomicVertex atomicVertex2 = (AtomicVertex)atomicVertex.getHeadVertex(i);
                if (!atomicVertex2.isGraphVertex() || (strongComponent2 = this.vertexToComponents.get(atomicVertex2)) == null || strongComponent2 == strongComponent) continue;
                strongComponent.addOutgoingArcTo(strongComponent2);
            }
        }
    }

    public StrongComponent[] getStrongComponents() {
        return this.graph;
    }

    @Override
    protected void initializeProcessing(Vertex[] vertexArray) {
        this.counter = 0;
        this.vertexStack.setSize(0);
        this.strongComponents.setSize(0);
        this.vertexToComponents.clear();
    }

    @Override
    protected void processAfter(Vertex vertex) {
        AtomicVertex atomicVertex = this.castAsAtomicVertex(vertex);
        if (atomicVertex.getLow() == atomicVertex.getOrder()) {
            StrongComponent strongComponent = new StrongComponent();
            while (!this.vertexStack.isEmpty() && this.vertexStack.peek().getOrder() >= atomicVertex.getOrder()) {
                AtomicVertex atomicVertex2 = this.vertexStack.pop();
                strongComponent.addVertex(atomicVertex2);
                this.vertexToComponents.put(atomicVertex2, strongComponent);
            }
            this.strongComponents.addElement(strongComponent);
        }
    }

    @Override
    protected void processArc(Vertex vertex, Vertex vertex2) {
        AtomicVertex atomicVertex = this.castAsAtomicVertex(vertex);
        AtomicVertex atomicVertex2 = this.castAsAtomicVertex(vertex2);
        if (atomicVertex2.isGraphVertex()) {
            if (!atomicVertex2.isVisited()) {
                this.process(atomicVertex2);
                atomicVertex.setLow(Math.min(atomicVertex.getLow(), atomicVertex2.getLow()));
            } else if (atomicVertex2.getOrder() < atomicVertex.getOrder() && this.vertexStack.contains(atomicVertex2)) {
                atomicVertex.setLow(Math.min(atomicVertex.getLow(), atomicVertex2.getOrder()));
            }
        }
    }

    @Override
    protected void processBefore(Vertex vertex) {
        AtomicVertex atomicVertex = this.castAsAtomicVertex(vertex);
        atomicVertex.setOrder(this.counter);
        atomicVertex.setLow(this.counter++);
        this.vertexStack.push(atomicVertex);
    }
}

