/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.LongestWalkProcessor;
import classycle.graph.StrongComponent;
import classycle.graph.StrongComponentProcessor;
import classycle.graph.Vertex;
import java.util.HashMap;
import java.util.Map;

public class StrongComponentAnalyser {
    private final AtomicVertex[] graph;
    private StrongComponent[] components;
    private HashMap<AtomicVertex, Integer> layerMap;

    public StrongComponentAnalyser(AtomicVertex[] atomicVertexArray) {
        this.graph = atomicVertexArray;
    }

    public StrongComponent[] getCondensedGraph() {
        if (this.components == null) {
            StrongComponentProcessor strongComponentProcessor = new StrongComponentProcessor(true);
            strongComponentProcessor.deepSearchFirst(this.graph);
            this.components = strongComponentProcessor.getStrongComponents();
        }
        return this.components;
    }

    public AtomicVertex[] getGraph() {
        return this.graph;
    }

    public Map<AtomicVertex, Integer> getLayerMap() {
        if (this.layerMap == null) {
            Vertex[] vertexArray = this.getCondensedGraph();
            new LongestWalkProcessor().deepSearchFirst(vertexArray);
            this.layerMap = new HashMap();
            for (int i = 0; i < vertexArray.length; ++i) {
                Vertex vertex = vertexArray[i];
                Integer n = new Integer(((StrongComponent)vertex).getLongestWalk());
                int n2 = ((StrongComponent)vertex).getNumberOfVertices();
                for (int j = 0; j < n2; ++j) {
                    this.layerMap.put(((StrongComponent)vertex).getVertex(j), n);
                }
            }
        }
        return this.layerMap;
    }
}

