/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.AtomicVertex;
import classycle.graph.GraphAttributes;
import classycle.graph.StrongComponentProcessor;
import classycle.graph.Vertex;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class StrongComponent
extends Vertex {
    private final Vector<AtomicVertex> vertices = new Vector();
    private boolean active;
    private int longestWalk;

    public StrongComponent() {
        super(new GeometryAttributes());
    }

    public void addVertex(AtomicVertex atomicVertex) {
        this.vertices.insertElementAt(atomicVertex, 0);
    }

    public void calculateAttributes() {
        int n;
        int n2;
        HashMap<AtomicVertex, Integer> hashMap = this.calculateIndexMap();
        int[][] nArray = this.calculateDistances(hashMap);
        GeometryAttributes geometryAttributes = (GeometryAttributes)this.getAttributes();
        int n3 = Integer.MAX_VALUE;
        int[] nArray2 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n3 = Math.min(n3, nArray[n2][n2]);
            nArray2[n2] = 0;
            for (n = 0; n < nArray.length; ++n) {
                if (n2 == n) continue;
                nArray2[n2] = Math.max(nArray2[n2], nArray[n2][n]);
            }
        }
        geometryAttributes.setEccentricities(nArray2);
        geometryAttributes.setGirth(n3);
        geometryAttributes.setMaximumFragmentSizes(this.calculateMaximumFragmentSizes(hashMap));
        n = geometryAttributes.getRadius();
        int n4 = geometryAttributes.getBestFragmentSize();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray2[n2] == n) {
                geometryAttributes.addVertex(this.getVertex(n2));
            }
            if (geometryAttributes.getMaximumFragmentSizes()[n2] != n4) continue;
            geometryAttributes.addFragmenter(this.getVertex(n2));
        }
    }

    private int[][] calculateDistances(HashMap<AtomicVertex, Integer> hashMap) {
        int n;
        int n2 = this.getNumberOfVertices();
        int[][] nArray = new int[n2][n2];
        for (n = 0; n < n2; ++n) {
            int n3;
            int[] nArray2 = nArray[n];
            AtomicVertex atomicVertex = this.getVertex(n);
            for (n3 = 0; n3 < n2; ++n3) {
                nArray2[n3] = 0x3FFFFFFF;
            }
            int n4 = atomicVertex.getNumberOfOutgoingArcs();
            for (n3 = 0; n3 < n4; ++n3) {
                Integer n5 = hashMap.get(atomicVertex.getHeadVertex(n3));
                if (n5 == null) continue;
                nArray2[n5.intValue()] = 1;
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (nArray[i][n] + nArray[n][j] >= nArray[i][j]) continue;
                    nArray[i][j] = nArray[i][n] + nArray[n][j];
                }
            }
        }
        return nArray;
    }

    private HashMap<AtomicVertex, Integer> calculateIndexMap() {
        HashMap<AtomicVertex, Integer> hashMap = new HashMap<AtomicVertex, Integer>();
        int n = this.getNumberOfVertices();
        for (int i = 0; i < n; ++i) {
            hashMap.put(this.getVertex(i), new Integer(i));
        }
        return hashMap;
    }

    private int[] calculateMaximumFragmentSizes(HashMap<AtomicVertex, Integer> hashMap) {
        int n;
        Object object;
        int n2;
        Vertex[] vertexArray = new AtomicVertex[this.getNumberOfVertices()];
        for (n2 = 0; n2 < vertexArray.length; ++n2) {
            vertexArray[n2] = new AtomicVertex(null);
        }
        for (n2 = 0; n2 < vertexArray.length; ++n2) {
            object = this.getVertex(n2);
            int n3 = ((Vertex)object).getNumberOfOutgoingArcs();
            for (n = 0; n < n3; ++n) {
                Integer n4 = hashMap.get(((Vertex)object).getHeadVertex(n));
                if (n4 == null) continue;
                vertexArray[n2].addOutgoingArcTo(vertexArray[n4]);
            }
        }
        StrongComponentProcessor strongComponentProcessor = new StrongComponentProcessor(false);
        object = new int[this.getNumberOfVertices()];
        for (n = 0; n < ((Object)object).length; ++n) {
            vertexArray[n].setDefaultValueOfGraphVertexFlag(false);
            strongComponentProcessor.deepSearchFirst(vertexArray);
            StrongComponent[] strongComponentArray = strongComponentProcessor.getStrongComponents();
            object[n] = false;
            for (int i = 0; i < strongComponentArray.length; ++i) {
                object[n] = Math.max((int)object[n], strongComponentArray[i].getNumberOfVertices());
            }
            ((AtomicVertex)vertexArray[n]).setDefaultValueOfGraphVertexFlag(true);
        }
        return object;
    }

    public int getLongestWalk() {
        return this.longestWalk;
    }

    public int getNumberOfVertices() {
        return this.vertices.size();
    }

    public AtomicVertex getVertex(int n) {
        return this.vertices.elementAt(n);
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void reset() {
        super.reset();
        this.active = false;
        this.longestWalk = -1;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setLongestWalk(int n) {
        this.longestWalk = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Strong component with ");
        int n = this.getNumberOfVertices();
        stringBuilder.append(n).append(n > 1 ? " vertices." : " vertex.");
        stringBuilder.append(" Longest walk: ").append(this.getLongestWalk());
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\n    ").append(this.getVertex(i));
        }
        return stringBuilder.toString();
    }

    public static Comparator<Vertex> comparatorByLongestWalk() {
        return (vertex, vertex2) -> {
            if (vertex instanceof StrongComponent && vertex2 instanceof StrongComponent) {
                StrongComponent strongComponent = (StrongComponent)vertex;
                StrongComponent strongComponent2 = (StrongComponent)vertex2;
                return strongComponent.getLongestWalk() - strongComponent2.getLongestWalk();
            }
            return 0;
        };
    }

    private static class GeometryAttributes
    implements GraphAttributes {
        private int girth;
        private int radius;
        private int diameter;
        private final List<Vertex> centerVertices = new ArrayList<Vertex>();
        private int[] eccentricities;
        private int[] maximumFragmentSizes;
        private int bestFragmentSize;
        private final List<Vertex> bestFragmenters = new ArrayList<Vertex>();

        void addFragmenter(Vertex vertex) {
            this.bestFragmenters.add(vertex);
        }

        void addVertex(Vertex vertex) {
            this.centerVertices.add(vertex);
        }

        @Override
        public Vertex[] getBestFragmenters() {
            return this.bestFragmenters.toArray(new Vertex[this.bestFragmenters.size()]);
        }

        @Override
        public int getBestFragmentSize() {
            return this.bestFragmentSize;
        }

        @Override
        public Vertex[] getCenterVertices() {
            return this.centerVertices.toArray(new Vertex[this.centerVertices.size()]);
        }

        @Override
        public int getDiameter() {
            return this.diameter;
        }

        @Override
        public int[] getEccentricities() {
            return this.eccentricities;
        }

        @Override
        public int getGirth() {
            return this.girth;
        }

        @Override
        public int[] getMaximumFragmentSizes() {
            return this.maximumFragmentSizes;
        }

        @Override
        public int getRadius() {
            return this.radius;
        }

        void setEccentricities(int[] nArray) {
            this.eccentricities = nArray;
            this.radius = Integer.MAX_VALUE;
            this.diameter = 0;
            for (int i = 0; i < nArray.length; ++i) {
                this.radius = Math.min(this.radius, nArray[i]);
                this.diameter = Math.max(this.diameter, nArray[i]);
            }
        }

        void setGirth(int n) {
            this.girth = n;
        }

        void setMaximumFragmentSizes(int[] nArray) {
            this.maximumFragmentSizes = nArray;
            this.bestFragmentSize = Integer.MAX_VALUE;
            for (int i = 0; i < nArray.length; ++i) {
                this.bestFragmentSize = Math.min(this.bestFragmentSize, nArray[i]);
            }
        }
    }
}

