/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.GraphProcessor;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import java.util.Arrays;

public class LongestWalkProcessor
extends GraphProcessor {
    private StrongComponent castAsStrongComponent(Vertex vertex) {
        if (vertex instanceof StrongComponent) {
            return (StrongComponent)vertex;
        }
        throw new IllegalArgumentException(vertex + " is not an instance of StrongComponent");
    }

    @Override
    protected void finishProcessing(Vertex[] vertexArray) {
        Arrays.sort(vertexArray, StrongComponent.comparatorByLongestWalk());
    }

    @Override
    protected void initializeProcessing(Vertex[] vertexArray) {
    }

    @Override
    protected void processAfter(Vertex vertex) {
        this.castAsStrongComponent(vertex).setActive(false);
    }

    @Override
    protected void processArc(Vertex vertex, Vertex vertex2) {
        StrongComponent strongComponent = this.castAsStrongComponent(vertex);
        StrongComponent strongComponent2 = this.castAsStrongComponent(vertex2);
        if (!strongComponent2.isVisited()) {
            this.process(strongComponent2);
        } else if (strongComponent2.isActive()) {
            throw new IllegalArgumentException(strongComponent2 + " is not a strong component.");
        }
        strongComponent.setLongestWalk(Math.max(strongComponent.getLongestWalk(), 1 + strongComponent2.getLongestWalk()));
    }

    @Override
    protected void processBefore(Vertex vertex) {
        StrongComponent strongComponent = this.castAsStrongComponent(vertex);
        strongComponent.setActive(true);
        strongComponent.setLongestWalk(0);
    }
}

