/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.CyclesResult;
import classycle.dependency.DependencyPathRenderer;
import classycle.dependency.DependencyPathsRenderer;
import classycle.dependency.DependencyResult;
import classycle.dependency.Preference;
import classycle.dependency.PreferenceFactory;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.TextResult;
import classycle.graph.Attributes;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import classycle.renderer.AbstractStrongComponentRenderer;
import classycle.util.StringPattern;
import classycle.util.Text;
import java.util.List;
import java.util.Stack;

public class XMLResultRenderer
extends ResultRenderer {
    private static final String ELEMENT_DEPENDENCY_RESULT = "dependency-checking-results";
    private static final String ATTRIBUTE_STATEMENT = "statement";

    private void addTo(XMLBuilder xMLBuilder, CyclesResult cyclesResult) {
        xMLBuilder.begin("cycles");
        xMLBuilder.attribute(ATTRIBUTE_STATEMENT, cyclesResult.getStatement());
        xMLBuilder.attribute("vertex-type", cyclesResult.isPackageCycle() ? "package" : "class");
        List<StrongComponent> list = cyclesResult.getCycles();
        for (StrongComponent strongComponent : list) {
            xMLBuilder.begin("cycle");
            xMLBuilder.attribute("name", AbstractStrongComponentRenderer.createName(strongComponent));
            int n = strongComponent.getNumberOfVertices();
            for (int i = 0; i < n; ++i) {
                xMLBuilder.begin("class");
                Attributes attributes = strongComponent.getVertex(i).getAttributes();
                if (attributes instanceof NameAttributes) {
                    xMLBuilder.text(((NameAttributes)attributes).getName());
                }
                xMLBuilder.end();
            }
            xMLBuilder.end();
        }
        xMLBuilder.end();
    }

    private void addTo(XMLBuilder xMLBuilder, DependencyResult dependencyResult) {
        xMLBuilder.begin("unexpected-dependencies");
        xMLBuilder.attribute(ATTRIBUTE_STATEMENT, dependencyResult.getStatement());
        Vertex[] vertexArray = dependencyResult.getPaths();
        StringPattern stringPattern = dependencyResult.getStartSet();
        StringPattern stringPattern2 = dependencyResult.getFinalSet();
        DependencyPathsRenderer dependencyPathsRenderer = new DependencyPathsRenderer(vertexArray, stringPattern, stringPattern2);
        dependencyPathsRenderer.renderGraph(this.createPathRenderer(xMLBuilder));
        xMLBuilder.end();
    }

    private void addTo(XMLBuilder xMLBuilder, Result result) {
        if (result instanceof CyclesResult) {
            this.addTo(xMLBuilder, (CyclesResult)result);
        } else if (result instanceof DependencyResult) {
            this.addTo(xMLBuilder, (DependencyResult)result);
        } else if (result instanceof ResultContainer) {
            this.addTo(xMLBuilder, (ResultContainer)result);
        } else if (result instanceof TextResult) {
            this.addTo(xMLBuilder, (TextResult)result);
        }
    }

    private void addTo(XMLBuilder xMLBuilder, ResultContainer resultContainer) {
        int n = resultContainer.getNumberOfResults();
        for (int i = 0; i < n; ++i) {
            this.addTo(xMLBuilder, resultContainer.getResult(i));
        }
    }

    private void addTo(XMLBuilder xMLBuilder, TextResult textResult) {
        if (!textResult.isOk() || textResult.toString().trim().length() > 0) {
            xMLBuilder.begin(textResult.isOk() ? "info" : "checking-error");
            xMLBuilder.text(textResult.toString());
            xMLBuilder.end();
        }
    }

    @Override
    public void considerPreference(Preference preference) {
    }

    private DependencyPathRenderer createPathRenderer(final XMLBuilder xMLBuilder) {
        return new DependencyPathRenderer(){
            private boolean openTag;

            @Override
            public void add(String string) {
                if (this.openTag) {
                    xMLBuilder.end();
                }
                xMLBuilder.begin("node");
                xMLBuilder.attribute("name", string);
                this.openTag = true;
            }

            @Override
            public void decreaseIndentation() {
                if (this.openTag) {
                    xMLBuilder.end();
                }
                this.openTag = false;
                xMLBuilder.end();
            }

            @Override
            public void increaseIndentation() {
                this.openTag = false;
            }
        };
    }

    @Override
    public Result getDescriptionOfCurrentPreferences() {
        return new TextResult("");
    }

    @Override
    public PreferenceFactory getPreferenceFactory() {
        return string -> () -> string;
    }

    @Override
    public String render(Result result) {
        XMLBuilder xMLBuilder = new XMLBuilder();
        xMLBuilder.begin(ELEMENT_DEPENDENCY_RESULT);
        this.addTo(xMLBuilder, result);
        xMLBuilder.end();
        return xMLBuilder.toString();
    }

    private static final class XMLBuilder {
        private static final int INDENTATION_INCREMENT = 2;
        private final StringBuilder builder = new StringBuilder("<?xml version='1.0' encoding='UTF-8'?>\n");
        private final Stack<String> stack = new Stack();
        private boolean unfinishedStartTag;
        private boolean textAdded;

        private XMLBuilder() {
        }

        void attribute(String string, String string2) {
            this.builder.append(' ').append(string).append("='").append(Text.excapeForXML(string2)).append("'");
        }

        void begin(String string) {
            if (this.unfinishedStartTag) {
                this.builder.append(">\n");
            }
            this.indent();
            this.builder.append("<").append(string);
            this.stack.push(string);
            this.unfinishedStartTag = true;
        }

        void end() {
            String string = this.stack.pop();
            if (this.unfinishedStartTag) {
                this.builder.append("/>\n");
                this.unfinishedStartTag = false;
            } else {
                if (!this.textAdded) {
                    this.indent();
                }
                this.textAdded = false;
                this.builder.append("</").append(string).append(">\n");
            }
        }

        private void indent() {
            for (int i = 0; i < this.stack.size() * 2; ++i) {
                this.builder.append(' ');
            }
        }

        void text(String string) {
            this.builder.append(">").append(Text.excapeForXML(string));
            this.unfinishedStartTag = false;
            this.textAdded = true;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

