/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyStatement;
import classycle.dependency.LayerDefinitionRepository;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.util.StringPattern;

public class LayeringStatement
implements Statement {
    private final StringPattern[][] layers;
    private final boolean strictLayering;
    private final SetDefinitionRepository repository;
    private final LayerDefinitionRepository layerRepository;
    private final ResultRenderer renderer;

    public LayeringStatement(StringPattern[][] stringPatternArray, boolean bl, SetDefinitionRepository setDefinitionRepository, LayerDefinitionRepository layerDefinitionRepository, ResultRenderer resultRenderer) {
        this.layers = stringPatternArray;
        this.repository = setDefinitionRepository;
        this.layerRepository = layerDefinitionRepository;
        this.strictLayering = bl;
        this.renderer = resultRenderer;
    }

    private void checkIntraLayerDependencies(ResultContainer resultContainer, StringPattern[] stringPatternArray, AtomicVertex[] atomicVertexArray) {
        StringPattern[] stringPatternArray2 = new StringPattern[1];
        StringPattern[] stringPatternArray3 = new StringPattern[stringPatternArray.length - 1];
        for (int i = 0; i < stringPatternArray.length; ++i) {
            stringPatternArray2[0] = stringPatternArray[i];
            System.arraycopy(stringPatternArray, 0, stringPatternArray3, 0, i);
            System.arraycopy(stringPatternArray, i + 1, stringPatternArray3, i, stringPatternArray.length - i - 1);
            DependencyStatement dependencyStatement = new DependencyStatement(stringPatternArray2, stringPatternArray3, "directlyIndependentOf", this.repository, this.renderer);
            resultContainer.add(dependencyStatement.execute(atomicVertexArray));
        }
    }

    @Override
    public Result execute(AtomicVertex[] atomicVertexArray) {
        ResultContainer resultContainer = new ResultContainer();
        for (int i = 0; i < this.layers.length; ++i) {
            DependencyStatement dependencyStatement;
            int n;
            this.checkIntraLayerDependencies(resultContainer, this.layers[i], atomicVertexArray);
            for (n = i + 1; n < this.layers.length; ++n) {
                dependencyStatement = new DependencyStatement(this.layers[i], this.layers[n], "directlyIndependentOf", this.repository, this.renderer);
                resultContainer.add(dependencyStatement.execute(atomicVertexArray));
            }
            if (!this.strictLayering) continue;
            for (n = i - 2; n >= 0; --n) {
                dependencyStatement = new DependencyStatement(this.layers[i], this.layers[n], "directlyIndependentOf", this.repository, this.renderer);
                resultContainer.add(dependencyStatement.execute(atomicVertexArray));
            }
        }
        return resultContainer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("check ");
        stringBuilder.append(this.strictLayering ? "strictLayeringOf" : "layeringOf");
        for (int i = 0; i < this.layers.length; ++i) {
            stringBuilder.append(' ').append(this.layerRepository.getName(this.layers[i]));
        }
        return stringBuilder.toString();
    }
}

