/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyResult;
import classycle.dependency.PatternVertexCondition;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.graph.PathsFinder;
import classycle.graph.Vertex;
import classycle.graph.VertexCondition;
import classycle.util.OrStringPattern;
import classycle.util.StringPattern;
import java.util.HashSet;

public class DependencyStatement
implements Statement {
    private static final String CHECK = "check ";
    private final StringPattern[] startSets;
    private final StringPattern[] finalSets;
    private final StringPattern finalSet;
    private final String dependencyType;
    private final VertexCondition[] startConditions;
    private final VertexCondition[] finalConditions;
    private final VertexCondition finalCondition;
    private final SetDefinitionRepository repository;
    private final ResultRenderer renderer;

    public DependencyStatement(StringPattern[] stringPatternArray, StringPattern[] stringPatternArray2, String string, SetDefinitionRepository setDefinitionRepository, ResultRenderer resultRenderer) {
        this.startSets = stringPatternArray;
        this.finalSets = stringPatternArray2;
        this.dependencyType = string;
        this.repository = setDefinitionRepository;
        this.renderer = resultRenderer;
        this.startConditions = this.createVertexConditions(stringPatternArray);
        this.finalConditions = this.createVertexConditions(stringPatternArray2);
        this.finalSet = new OrStringPattern(stringPatternArray2);
        this.finalCondition = new VertexUnionCondition(this.finalConditions);
    }

    private VertexCondition[] createVertexConditions(StringPattern[] stringPatternArray) {
        VertexCondition[] vertexConditionArray = new VertexCondition[stringPatternArray.length];
        for (int i = 0; i < vertexConditionArray.length; ++i) {
            vertexConditionArray[i] = new PatternVertexCondition(stringPatternArray[i]);
        }
        return vertexConditionArray;
    }

    @Override
    public Result execute(AtomicVertex[] atomicVertexArray) {
        ResultContainer resultContainer = new ResultContainer();
        boolean bl = "directlyIndependentOf".equals(this.dependencyType);
        boolean bl2 = "dependentOnlyOn".equals(this.dependencyType);
        for (int i = 0; i < this.startConditions.length; ++i) {
            VertexCondition vertexCondition = this.startConditions[i];
            StringPattern stringPattern = this.startSets[i];
            if (bl2) {
                HashSet<AtomicVertex> hashSet = new HashSet<AtomicVertex>();
                for (AtomicVertex atomicVertex : atomicVertexArray) {
                    if (!vertexCondition.isFulfilled(atomicVertex)) continue;
                    int n = atomicVertex.getNumberOfOutgoingArcs();
                    for (int j = 0; j < n; ++j) {
                        Vertex vertex = atomicVertex.getHeadVertex(j);
                        if (this.finalCondition.isFulfilled(vertex) || vertexCondition.isFulfilled(vertex)) continue;
                        hashSet.add(atomicVertex);
                        hashSet.add((AtomicVertex)vertex);
                    }
                }
                resultContainer.add(new DependencyResult(stringPattern, this.finalSet, this.toString(stringPattern, this.finalSet), hashSet.toArray(new AtomicVertex[0])));
                continue;
            }
            for (int j = 0; j < this.finalConditions.length; ++j) {
                PathsFinder pathsFinder = new PathsFinder(vertexCondition, this.finalConditions[j], this.renderer.onlyShortestPaths(), bl);
                resultContainer.add(new DependencyResult(stringPattern, this.finalSets[j], this.toString(i, j), pathsFinder.findPaths(atomicVertexArray)));
            }
        }
        return resultContainer;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(CHECK);
        for (n = 0; n < this.startSets.length; ++n) {
            stringBuilder.append(this.repository.toString(this.startSets[n])).append(' ');
        }
        stringBuilder.append(this.dependencyType).append(' ');
        for (n = 0; n < this.finalSets.length; ++n) {
            stringBuilder.append(this.repository.toString(this.finalSets[n])).append(' ');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1).toString();
    }

    private String toString(int n, int n2) {
        return this.toString(this.startSets[n], this.finalSets[n2]);
    }

    private String toString(StringPattern stringPattern, StringPattern stringPattern2) {
        StringBuilder stringBuilder = new StringBuilder(CHECK);
        stringBuilder.append(this.repository.toString(stringPattern)).append(' ').append(this.dependencyType).append(' ').append(this.repository.toString(stringPattern2));
        return stringBuilder.toString();
    }

    private static final class VertexUnionCondition
    implements VertexCondition {
        private final VertexCondition[] conditions;

        VertexUnionCondition(VertexCondition[] vertexConditionArray) {
            this.conditions = vertexConditionArray;
        }

        @Override
        public boolean isFulfilled(Vertex vertex) {
            for (VertexCondition vertexCondition : this.conditions) {
                if (!vertexCondition.isFulfilled(vertex)) continue;
                return true;
            }
            return false;
        }
    }
}

