/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyPathsRenderer;
import classycle.dependency.Result;
import classycle.graph.AtomicVertex;
import classycle.graph.Vertex;
import classycle.util.StringPattern;

public class DependencyResult
implements Result {
    private static final String OK = "\tOK";
    private static final String DEPENDENCIES_FOUND = "\n  Unexpected dependencies found:";
    private final StringPattern startSet;
    private final StringPattern finalSet;
    private final String statement;
    private final AtomicVertex[] paths;
    private final boolean ok;

    public DependencyResult(StringPattern stringPattern, StringPattern stringPattern2, String string, AtomicVertex[] atomicVertexArray) {
        this.startSet = stringPattern;
        this.finalSet = stringPattern2;
        this.statement = string;
        this.paths = atomicVertexArray;
        this.ok = atomicVertexArray.length == 0;
    }

    public StringPattern getFinalSet() {
        return this.finalSet;
    }

    public AtomicVertex[] getPaths() {
        return this.paths;
    }

    public StringPattern getStartSet() {
        return this.startSet;
    }

    public String getStatement() {
        return this.statement;
    }

    @Override
    public boolean isOk() {
        return this.ok;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.statement);
        if (this.ok) {
            stringBuilder.append(OK);
        } else {
            DependencyPathsRenderer dependencyPathsRenderer = new DependencyPathsRenderer((Vertex[])this.paths, this.startSet, this.finalSet);
            stringBuilder.append(DEPENDENCIES_FOUND).append(dependencyPathsRenderer.renderGraph("  "));
        }
        return stringBuilder.append('\n').toString();
    }
}

