/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyPathRenderer;
import classycle.dependency.PatternVertexCondition;
import classycle.graph.NameAttributes;
import classycle.graph.Vertex;
import classycle.graph.VertexCondition;
import classycle.util.StringPattern;
import java.util.HashSet;
import java.util.Set;

public class DependencyPathsRenderer {
    private static final String INDENT = "  ";
    private final Vertex[] graph;
    private final VertexCondition startSetCondition;
    private final VertexCondition finalSetCondition;
    private final Set<Vertex> vertices = new HashSet<Vertex>();

    public DependencyPathsRenderer(Vertex[] vertexArray, StringPattern stringPattern, StringPattern stringPattern2) {
        this(vertexArray, new PatternVertexCondition(stringPattern), new PatternVertexCondition(stringPattern2));
    }

    public DependencyPathsRenderer(Vertex[] vertexArray, VertexCondition vertexCondition, VertexCondition vertexCondition2) {
        this.graph = vertexArray;
        this.startSetCondition = vertexCondition;
        this.finalSetCondition = vertexCondition2;
        for (int i = 0; i < vertexArray.length; ++i) {
            this.vertices.add(vertexArray[i]);
        }
    }

    private String getNameOf(Vertex vertex) {
        return ((NameAttributes)vertex.getAttributes()).getName();
    }

    public void renderGraph(DependencyPathRenderer dependencyPathRenderer) {
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        for (int i = 0; i < this.graph.length; ++i) {
            Vertex vertex = this.graph[i];
            if (!this.startSetCondition.isFulfilled(vertex)) continue;
            dependencyPathRenderer.add(this.getNameOf(vertex));
            this.renderPaths(dependencyPathRenderer, vertex, hashSet);
        }
    }

    public String renderGraph(final String string) {
        final StringBuilder stringBuilder = new StringBuilder();
        DependencyPathRenderer dependencyPathRenderer = new DependencyPathRenderer(){
            String start;
            private int indentation;
            {
                this.start = '\n' + string;
            }

            @Override
            public void add(String string2) {
                stringBuilder.append(this.start);
                for (int i = 0; i < this.indentation; ++i) {
                    stringBuilder.append(DependencyPathsRenderer.INDENT);
                }
                if (this.indentation > 0) {
                    stringBuilder.append("-> ");
                }
                stringBuilder.append(string2);
            }

            @Override
            public void decreaseIndentation() {
                --this.indentation;
            }

            @Override
            public void increaseIndentation() {
                ++this.indentation;
            }
        };
        this.renderGraph(dependencyPathRenderer);
        return stringBuilder.toString();
    }

    private void renderPaths(DependencyPathRenderer dependencyPathRenderer, Vertex vertex, Set<Vertex> set) {
        set.add(vertex);
        dependencyPathRenderer.increaseIndentation();
        int n = vertex.getNumberOfOutgoingArcs();
        for (int i = 0; i < n; ++i) {
            Vertex vertex2 = vertex.getHeadVertex(i);
            if (!this.vertices.contains(vertex2) || this.startSetCondition.isFulfilled(vertex2)) continue;
            dependencyPathRenderer.add(this.getNameOf(vertex2));
            if (this.finalSetCondition.isFulfilled(vertex2) || set.contains(vertex2)) continue;
            this.renderPaths(dependencyPathRenderer, vertex2, set);
        }
        dependencyPathRenderer.decreaseIndentation();
    }
}

