/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.CheckCyclesStatement;
import classycle.dependency.CheckSetStatement;
import classycle.dependency.DependencyProperties;
import classycle.dependency.DependencyStatement;
import classycle.dependency.LayerDefinitionRepository;
import classycle.dependency.LayeringStatement;
import classycle.dependency.Preference;
import classycle.dependency.ResultRenderer;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.ShowStatement;
import classycle.dependency.Statement;
import classycle.util.AndStringPattern;
import classycle.util.NotStringPattern;
import classycle.util.OrStringPattern;
import classycle.util.StringPattern;
import classycle.util.WildCardPattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;

public class DependencyDefinitionParser {
    public static final String INDEPENDENT_OF_KEY_WORD = "independentOf";
    public static final String EXCLUDING_KEY_WORD = "excluding";
    public static final String DIRECTLY_INDEPENDENT_OF_KEY_WORD = "directlyIndependentOf";
    public static final String DEPENDENT_ONLY_ON_KEY_WORD = "dependentOnlyOn";
    public static final String CHECK_KEY_WORD = "check";
    public static final String LAYER_KEY_WORD = "layer";
    public static final String SHOW_KEY_WORD = "show";
    public static final String SETS_KEY_WORD = "sets";
    public static final String CLASS_CYCLES_KEY_WORD = "absenceOfClassCycles";
    public static final String PACKAGE_CYCLES_KEY_WORD = "absenceOfPackageCycles";
    public static final String IN_KEY_WORD = "in";
    public static final String LAYERING_OF_KEY_WORD = "layeringOf";
    public static final String STRICT_LAYERING_OF_KEY_WORD = "strictLayeringOf";
    private static final String[] INDEPENDENT = new String[]{"independentOf", "directlyIndependentOf", "dependentOnlyOn"};
    private static final String[] EXCLUDING = new String[]{"excluding"};
    private static final String PROP_DEF_BEGIN = "{";
    private static final String PROP_BEGIN = "${";
    private static final String PROP_END = "}";
    private final DependencyProperties properties;
    private final ResultRenderer renderer;
    final SetDefinitionRepository setDefinitions = new SetDefinitionRepository();
    final LayerDefinitionRepository layerDefinitions = new LayerDefinitionRepository();
    private final List<Statement> statements = new ArrayList<Statement>();

    public DependencyDefinitionParser(String string, DependencyProperties dependencyProperties, ResultRenderer resultRenderer) {
        this.properties = dependencyProperties;
        this.renderer = resultRenderer;
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new StringReader(string));){
            String string2;
            int n = 0;
            int n2 = 1;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if ((string2 = string2.trim()).startsWith("#")) continue;
                stringBuilder.append(string2);
                if (string2.endsWith("\\")) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1).append(' ');
                    continue;
                }
                String string3 = this.replaceProperties(stringBuilder.toString().trim(), n2);
                if (string3.length() > 0) {
                    this.parseLine(string3, n2);
                }
                stringBuilder.setLength(0);
                n2 = n + 1;
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    private void checkForEqualCharacter(String[] stringArray, int n, int n2) {
        if (stringArray.length < n2 + 1 || !stringArray[n2].equals("=")) {
            this.throwException("'=' missing.", n, n2);
        }
    }

    private void createCheckSetStatements(String[] stringArray, int n) {
        if (stringArray.length < 3) {
            this.throwException("No sets to check.", n, 2);
        }
        for (int i = 2; i < stringArray.length; ++i) {
            StringPattern stringPattern = this.createPattern(stringArray[i], n, i);
            this.statements.add(new CheckSetStatement(stringPattern, this.setDefinitions));
        }
    }

    private void createCyclesStatement(String[] stringArray, int n) {
        boolean bl = stringArray[1].equals(PACKAGE_CYCLES_KEY_WORD);
        if (stringArray.length != 6) {
            this.throwException("Invalid statement.", n, stringArray.length);
        }
        if (!stringArray[2].equals(">")) {
            this.throwException("'>' expected.", n, 2);
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            this.throwException("Number expected.", n, 3);
        }
        if (n2 < 1) {
            this.throwException("Size has to be >= 1", n, 3);
        }
        if (!stringArray[4].equals(IN_KEY_WORD)) {
            this.throwException("'in' expected.", n, 4);
        }
        StringPattern stringPattern = this.createPattern(stringArray[5], n, 4);
        this.statements.add(new CheckCyclesStatement(stringPattern, n2, bl, this.setDefinitions));
    }

    private void createDependencyStatement(String[] stringArray, int n) {
        StringPattern[][] stringPatternArray = this.getLists(stringArray, n, INDEPENDENT, 1);
        if (stringPatternArray[0].length == 0) {
            this.throwException("Missing start sets.", n, 1);
        }
        if (stringPatternArray[1].length == 0) {
            this.throwException("Missing end sets. Probably one of the following key words are missing: " + Arrays.asList(INDEPENDENT), n, stringArray.length);
        }
        this.statements.add(new DependencyStatement(stringPatternArray[0], stringPatternArray[1], stringArray[stringPatternArray[0].length + 1], this.setDefinitions, this.renderer));
    }

    private void createLayeringStatement(String[] stringArray, int n) {
        int n2;
        StringPattern[][] stringPatternArray = new StringPattern[stringArray.length - 2][];
        for (n2 = 0; n2 < stringPatternArray.length; ++n2) {
            String string = stringArray[n2 + 2];
            stringPatternArray[n2] = this.layerDefinitions.getLayer(string);
            if (stringPatternArray[n2] != null) continue;
            this.throwException("Undefined layer '" + string + "'.", n, n2 + 2);
        }
        n2 = stringArray[1].equals(STRICT_LAYERING_OF_KEY_WORD) ? 1 : 0;
        this.statements.add(new LayeringStatement(stringPatternArray, n2 != 0, this.setDefinitions, this.layerDefinitions, this.renderer));
    }

    private StringPattern createOrSequence(StringPattern[] stringPatternArray) {
        OrStringPattern orStringPattern = new OrStringPattern(new StringPattern[0]);
        for (int i = 0; i < stringPatternArray.length; ++i) {
            orStringPattern.appendPattern(stringPatternArray[i]);
        }
        return orStringPattern;
    }

    private StringPattern createPattern(String string, int n, int n2) {
        StringPattern stringPattern = this.setDefinitions.getPattern(string);
        if (stringPattern == null) {
            if (string.startsWith("[") && string.endsWith("]")) {
                this.throwException("Set " + string + " is undefined.", n, n2);
            }
            if (string.indexOf(46) < 0 && string.indexOf(42) < 0 && string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
                this.throwException("Patterns without a '.' and a '*' should not start with a lower-case letter: " + string, n, n2);
            }
            stringPattern = new WildCardPattern(string);
        }
        return stringPattern;
    }

    private StringPattern[][] getLists(String[] stringArray, int n, String[] stringArray2, int n2) {
        ArrayList<StringPattern> arrayList = new ArrayList<StringPattern>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<StringPattern> arrayList3 = arrayList;
        for (int i = n2; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (this.isAKeyWord(string, stringArray2)) {
                if (arrayList3 == arrayList2) {
                    this.throwException("Invalid appearance of key word '" + string + "'.", n, i);
                }
                arrayList3 = arrayList2;
                continue;
            }
            arrayList3.add(this.createPattern(string, n, i));
        }
        StringPattern[][] stringPatternArray = new StringPattern[][]{arrayList.toArray(new StringPattern[0]), arrayList2.toArray(new StringPattern[0])};
        return stringPatternArray;
    }

    public Statement[] getStatements() {
        return this.statements.toArray(new Statement[0]);
    }

    private boolean isAKeyWord(String string, String[] stringArray) {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void parseCheckStatement(String[] stringArray, int n) {
        if (stringArray.length < 2) {
            this.throwException("Missing checking statement.", n, 1);
        }
        if (stringArray[1].equals(STRICT_LAYERING_OF_KEY_WORD) || stringArray[1].equals(LAYERING_OF_KEY_WORD)) {
            this.createLayeringStatement(stringArray, n);
        } else if (stringArray[1].equals(SETS_KEY_WORD)) {
            this.createCheckSetStatements(stringArray, n);
        } else if (stringArray[1].equals(CLASS_CYCLES_KEY_WORD) || stringArray[1].equals(PACKAGE_CYCLES_KEY_WORD)) {
            this.createCyclesStatement(stringArray, n);
        } else {
            this.createDependencyStatement(stringArray, n);
        }
    }

    private void parseLayerDefinition(String[] stringArray, int n) {
        String string;
        if (stringArray.length < 2) {
            this.throwException("Missing layer name.", n, 1);
        }
        if (this.layerDefinitions.contains(string = stringArray[1])) {
            this.throwException("Layer '" + string + "' already defined.", n, 1);
        }
        this.checkForEqualCharacter(stringArray, n, 2);
        if (stringArray.length < 4) {
            this.throwException("Missing terms in definition of layer '" + string + "'.", n, 3);
        }
        ArrayList<StringPattern> arrayList = new ArrayList<StringPattern>();
        for (int i = 3; i < stringArray.length; ++i) {
            arrayList.add(this.createPattern(stringArray[i], n, i));
        }
        StringPattern[] stringPatternArray = new StringPattern[arrayList.size()];
        this.layerDefinitions.put(string, arrayList.toArray(stringPatternArray));
    }

    private void parseLine(String string, int n) {
        if (string.startsWith(PROP_DEF_BEGIN)) {
            this.parsePropertyDefinition(string, n);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string2 = stringArray[0];
        if (string2.startsWith("[")) {
            this.parseSetDefinition(stringArray, n);
        } else if (string2.equals(SHOW_KEY_WORD)) {
            this.parseShowStatement(stringArray, n);
        } else if (string2.equals(LAYER_KEY_WORD)) {
            this.parseLayerDefinition(stringArray, n);
        } else if (string2.equals(CHECK_KEY_WORD)) {
            this.parseCheckStatement(stringArray, n);
        } else {
            this.throwException("Expecting either a property definition, a set name, 'show', 'layer', or 'check'.", n, 0);
        }
    }

    private void parsePropertyDefinition(String string, int n) {
        int n2 = string.indexOf(PROP_END);
        if (n2 < 0) {
            this.throwException("Missing '}' in property definition.", n, -1);
        }
        String string2 = string.substring(PROP_DEF_BEGIN.length(), n2);
        String string3 = string.substring(n2 + PROP_END.length()).trim();
        if (!string3.startsWith("=")) {
            this.throwException("Missing '=' in propety definition.", n, -1);
        }
        this.properties.setProperty(string2, string3.substring(1).trim());
    }

    private void parseSetDefinition(String[] stringArray, int n) {
        String string = stringArray[0];
        if (!string.endsWith("]")) {
            this.throwException("Set name has to end with ']'.", n, 0);
        }
        if (this.setDefinitions.contains(string)) {
            this.throwException("Set " + string + " already defined.", n, 0);
        }
        this.checkForEqualCharacter(stringArray, n, 1);
        StringPattern[][] stringPatternArray = this.getLists(stringArray, n, EXCLUDING, 2);
        if (stringPatternArray[0].length == 0 && stringPatternArray[1].length == 0) {
            this.throwException("Missing terms in set definition.", n, 2);
        }
        AndStringPattern andStringPattern = new AndStringPattern(new StringPattern[0]);
        if (stringPatternArray[0].length > 0) {
            andStringPattern.appendPattern(this.createOrSequence(stringPatternArray[0]));
        }
        if (stringPatternArray[1].length > 0) {
            andStringPattern.appendPattern(new NotStringPattern(this.createOrSequence(stringPatternArray[1])));
        }
        this.setDefinitions.put(string, andStringPattern);
    }

    private void parseShowStatement(String[] stringArray, int n) {
        if (stringArray.length < 2) {
            this.throwException("Missing display preference(s).", n, 1);
        }
        Preference[] preferenceArray = new Preference[stringArray.length - 1];
        for (int i = 0; i < preferenceArray.length; ++i) {
            preferenceArray[i] = this.renderer.getPreferenceFactory().get(stringArray[i + 1]);
            if (preferenceArray[i] != null) continue;
            this.throwException("Unknown display preference: " + stringArray[i + 1], n, i + 1);
        }
        this.statements.add(new ShowStatement(this.renderer, preferenceArray));
    }

    private String replaceProperties(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.indexOf(PROP_BEGIN, n2);
            if (n3 >= 0) {
                stringBuilder.append(string.substring(n2, n3));
                n2 = string.indexOf(PROP_END, n3);
                if (n2 < 0) {
                    this.throwException("Missing '}'.", n, -1);
                }
                String string2 = string.substring(n3 + PROP_BEGIN.length(), n2);
                n2 += PROP_END.length();
                String string3 = this.properties.getProperty(string2);
                if (string3 == null) {
                    String string4 = "Undefines property " + string.substring(n3, n2);
                    this.throwException(string4, n, -1);
                    continue;
                }
                stringBuilder.append(string3);
                continue;
            }
            stringBuilder.append(string.substring(n2));
            n2 = string.length();
        }
        return stringBuilder.toString();
    }

    private void throwException(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder("Error in line ");
        stringBuilder.append(n);
        if (n2 >= 0) {
            stringBuilder.append(" token ").append(n2 + 1);
        }
        stringBuilder.append(": ").append(string);
        throw new IllegalArgumentException(stringBuilder.toString());
    }
}

