/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.CommandLine;
import classycle.dependency.DefaultResultRenderer;
import classycle.dependency.ResultRenderer;
import classycle.util.Text;
import java.io.File;
import java.io.IOException;

public class DependencyCheckerCommandLine
extends CommandLine {
    private static final String DEPENDENCIES = "-dependencies=";
    private static final String RENDERER = "-renderer=";
    private String dependencyDefinition;
    private ResultRenderer renderer;

    public DependencyCheckerCommandLine(String[] stringArray) {
        super(stringArray);
    }

    public String getDependencyDefinition() {
        return this.dependencyDefinition;
    }

    public ResultRenderer getRenderer() {
        return this.renderer == null ? new DefaultResultRenderer() : this.renderer;
    }

    @Override
    public String getUsage() {
        return "-dependencies=<description>|@<description file> [-renderer=<fully qualified class name of a ResultRenderer>] " + super.getUsage();
    }

    private void handleDependenciesOption(String string) {
        if (string.startsWith("@")) {
            try {
                string = Text.readTextFile(new File(string.substring(1)));
            }
            catch (IOException iOException) {
                System.err.println("Error in reading dependencies description file: " + iOException);
                string = "";
            }
        }
        this.dependencyDefinition = string;
        if (this.dependencyDefinition.length() == 0) {
            this.valid = false;
        }
    }

    @Override
    protected void handleOption(String string) {
        if (string.startsWith(DEPENDENCIES)) {
            this.handleDependenciesOption(string.substring(DEPENDENCIES.length()));
        } else if (string.startsWith(RENDERER)) {
            this.handleRenderer(string.substring(RENDERER.length()));
        } else {
            super.handleOption(string);
        }
    }

    private void handleRenderer(String string) {
        try {
            this.renderer = (ResultRenderer)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Error in creating ResultRenderer " + string + ": " + exception);
            this.valid = false;
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.dependencyDefinition != null;
    }
}

