/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.Analyser;
import classycle.dependency.DependencyCheckerCommandLine;
import classycle.dependency.DependencyProcessor;
import classycle.dependency.DependencyProperties;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.graph.AtomicVertex;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class DependencyChecker {
    private final Analyser analyser;
    private final ResultRenderer renderer;
    private final DependencyProcessor processor;

    public DependencyChecker(Analyser analyser, String string, Map<String, String> map, ResultRenderer resultRenderer) {
        this.analyser = analyser;
        this.renderer = resultRenderer;
        DependencyProperties dependencyProperties = new DependencyProperties(map);
        this.processor = new DependencyProcessor(string, dependencyProperties, resultRenderer);
    }

    public Result check() {
        AtomicVertex[] atomicVertexArray = this.analyser.getClassGraph();
        ResultContainer resultContainer = new ResultContainer();
        while (this.processor.hasMoreStatements()) {
            resultContainer.add(this.processor.executeNextStatement(atomicVertexArray));
        }
        return resultContainer;
    }

    public boolean check(PrintWriter printWriter) {
        Result result = this.check();
        printWriter.print(this.renderer.render(result));
        return result.isOk();
    }

    public static void main(String[] stringArray) {
        DependencyCheckerCommandLine dependencyCheckerCommandLine = new DependencyCheckerCommandLine(stringArray);
        if (!dependencyCheckerCommandLine.isValid()) {
            System.out.println("Usage: java -cp classycle.jar classycle.DependencyChecker " + dependencyCheckerCommandLine.getUsage());
            System.exit(1);
        }
        Analyser analyser = new Analyser(dependencyCheckerCommandLine.getClassFiles(), dependencyCheckerCommandLine.getPattern(), dependencyCheckerCommandLine.getReflectionPattern(), dependencyCheckerCommandLine.isMergeInnerClasses());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object2 : System.getProperties().stringPropertyNames()) {
            hashMap.put(object2, System.getProperties().getProperty(object2));
        }
        DependencyChecker dependencyChecker = new DependencyChecker(analyser, dependencyCheckerCommandLine.getDependencyDefinition(), hashMap, dependencyCheckerCommandLine.getRenderer());
        PrintWriter printWriter = new PrintWriter(System.out);
        boolean bl = dependencyChecker.check(printWriter);
        printWriter.flush();
        System.exit(bl ? 0 : 1);
    }
}

