/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DefaultPreferenceFactory;
import classycle.dependency.Preference;
import classycle.dependency.PreferenceFactory;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.TextResult;

public class DefaultResultRenderer
extends ResultRenderer {
    private static final String SHOW = "show ";
    private static final PreferenceFactory FACTORY = new DefaultPreferenceFactory();
    private boolean allResults;

    @Override
    public void considerPreference(Preference preference) {
        if (preference == DefaultPreferenceFactory.ONLY_SHORTEST_PATHS) {
            this.shortestPaths = true;
        } else if (preference == DefaultPreferenceFactory.ALL_PATHS) {
            this.shortestPaths = false;
        } else if (preference == DefaultPreferenceFactory.ALL_RESULTS) {
            this.allResults = true;
        } else if (preference == DefaultPreferenceFactory.ONLY_FAILURES) {
            this.allResults = false;
        }
    }

    @Override
    public Result getDescriptionOfCurrentPreferences() {
        StringBuilder stringBuilder = new StringBuilder(SHOW);
        stringBuilder.append(this.shortestPaths ? DefaultPreferenceFactory.ONLY_SHORTEST_PATHS.getKey() : DefaultPreferenceFactory.ALL_PATHS.getKey()).append(' ').append(this.allResults ? DefaultPreferenceFactory.ALL_RESULTS.getKey() : DefaultPreferenceFactory.ONLY_FAILURES.getKey()).append('\n');
        return new TextResult(stringBuilder.toString());
    }

    @Override
    public PreferenceFactory getPreferenceFactory() {
        return FACTORY;
    }

    @Override
    public String render(Result result) {
        StringBuilder stringBuilder = new StringBuilder();
        this.render(stringBuilder, result);
        return stringBuilder.toString();
    }

    private void render(StringBuilder stringBuilder, Result result) {
        if (result instanceof ResultContainer) {
            ResultContainer resultContainer = (ResultContainer)result;
            int n = resultContainer.getNumberOfResults();
            for (int i = 0; i < n; ++i) {
                this.render(stringBuilder, resultContainer.getResult(i));
            }
        } else if (this.allResults || !result.isOk()) {
            stringBuilder.append(result.toString());
        }
    }
}

