/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.Result;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.renderer.AbstractStrongComponentRenderer;
import java.util.ArrayList;
import java.util.List;

public class CyclesResult
implements Result {
    private final List<StrongComponent> cycles = new ArrayList<StrongComponent>();
    private final String statement;
    private final boolean packageCycle;

    public CyclesResult(String string, boolean bl) {
        this.statement = string;
        this.packageCycle = bl;
    }

    public void addCycle(StrongComponent strongComponent) {
        this.cycles.add(strongComponent);
    }

    public List<StrongComponent> getCycles() {
        return this.cycles;
    }

    public String getStatement() {
        return this.statement;
    }

    @Override
    public boolean isOk() {
        return this.cycles.size() == 0;
    }

    public boolean isPackageCycle() {
        return this.packageCycle;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.statement);
        if (this.isOk()) {
            stringBuilder.append("\tOK");
        } else {
            for (StrongComponent strongComponent : this.cycles) {
                int n = strongComponent.getNumberOfVertices();
                stringBuilder.append("\n  ");
                stringBuilder.append(AbstractStrongComponentRenderer.createName(strongComponent));
                stringBuilder.append(" contains ").append(n);
                stringBuilder.append(' ').append(this.packageCycle ? "packages" : "classes").append(':');
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append("\n    ");
                    AtomicVertex atomicVertex = strongComponent.getVertex(i);
                    stringBuilder.append(((NameAttributes)atomicVertex.getAttributes()).getName());
                }
            }
        }
        return stringBuilder.append('\n').toString();
    }
}

