/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.Result;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.dependency.TextResult;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.util.StringPattern;

public class CheckSetStatement
implements Statement {
    private final StringPattern set;
    private final SetDefinitionRepository repository;

    public CheckSetStatement(StringPattern stringPattern, SetDefinitionRepository setDefinitionRepository) {
        this.set = stringPattern;
        this.repository = setDefinitionRepository;
    }

    @Override
    public Result execute(AtomicVertex[] atomicVertexArray) {
        int n = 0;
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            if (!this.set.matches(((NameAttributes)atomicVertexArray[i].getAttributes()).getName())) continue;
            ++n;
        }
        StringBuilder stringBuilder = new StringBuilder("Set ");
        stringBuilder.append(this.repository.toString(this.set));
        if (n == 0) {
            stringBuilder.append(" is empty.");
        } else if (n == 1) {
            stringBuilder.append(" has one class.");
        } else {
            stringBuilder.append(" has ").append(n).append(" classes.");
        }
        return new TextResult(stringBuilder.append('\n').toString(), n > 0);
    }

    public String toString() {
        return "check set " + this.repository.toString(this.set);
    }
}

