/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.PackageProcessor;
import classycle.dependency.CyclesResult;
import classycle.dependency.Result;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.graph.StrongComponentAnalyser;
import classycle.util.StringPattern;
import java.util.ArrayList;

public class CheckCyclesStatement
implements Statement {
    private final StringPattern set;
    private final int maximumSize;
    private final boolean packageCycles;
    private final SetDefinitionRepository repository;

    public CheckCyclesStatement(StringPattern stringPattern, int n, boolean bl, SetDefinitionRepository setDefinitionRepository) {
        this.set = stringPattern;
        this.maximumSize = n;
        this.packageCycles = bl;
        this.repository = setDefinitionRepository;
    }

    private String createStatement() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("check").append(' ');
        if (this.packageCycles) {
            stringBuilder.append("absenceOfPackageCycles");
        } else {
            stringBuilder.append("absenceOfClassCycles");
        }
        stringBuilder.append(" > ").append(this.maximumSize).append(' ');
        stringBuilder.append("in").append(' ');
        stringBuilder.append(this.repository.toString(this.set));
        return stringBuilder.toString();
    }

    @Override
    public Result execute(AtomicVertex[] atomicVertexArray) {
        ArrayList<AtomicVertex> arrayList = new ArrayList<AtomicVertex>();
        for (int i = 0; i < atomicVertexArray.length; ++i) {
            if (!this.set.matches(((NameAttributes)atomicVertexArray[i].getAttributes()).getName())) continue;
            arrayList.add(atomicVertexArray[i]);
        }
        atomicVertexArray = arrayList.toArray(new AtomicVertex[0]);
        if (this.packageCycles) {
            PackageProcessor packageProcessor = new PackageProcessor();
            packageProcessor.deepSearchFirst(atomicVertexArray);
            atomicVertexArray = packageProcessor.getGraph();
        }
        StrongComponentAnalyser strongComponentAnalyser = new StrongComponentAnalyser(atomicVertexArray);
        StrongComponent[] strongComponentArray = strongComponentAnalyser.getCondensedGraph();
        CyclesResult cyclesResult = new CyclesResult(this.createStatement(), this.packageCycles);
        for (int i = 0; i < strongComponentArray.length; ++i) {
            StrongComponent strongComponent = strongComponentArray[i];
            if (strongComponent.getNumberOfVertices() <= this.maximumSize) continue;
            cyclesResult.addCycle(strongComponent);
        }
        return cyclesResult;
    }

    public String toString() {
        return this.createStatement();
    }
}

