/*
 * Decompiled with CFR 0.152.
 */
package classycle.classfile;

import classycle.classfile.ClassConstant;
import classycle.classfile.DoubleConstant;
import classycle.classfile.FieldRefConstant;
import classycle.classfile.FloatConstant;
import classycle.classfile.IntConstant;
import classycle.classfile.InterfaceMethodRefConstant;
import classycle.classfile.InvokeDynamicConstant;
import classycle.classfile.LongConstant;
import classycle.classfile.MethodHandleConstant;
import classycle.classfile.MethodRefConstant;
import classycle.classfile.MethodTypeConstant;
import classycle.classfile.ModuleConstant;
import classycle.classfile.NameAndTypeConstant;
import classycle.classfile.PackageConstant;
import classycle.classfile.StringConstant;
import classycle.classfile.UTF8Constant;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class Constant {
    private static final int MAGIC = -889275714;
    private static final int CONSTANT_CLASS = 7;
    private static final int CONSTANT_FIELDREF = 9;
    private static final int CONSTANT_METHODREF = 10;
    private static final int CONSTANT_INTERFACE_METHODREF = 11;
    private static final int CONSTANT_STRING = 8;
    private static final int CONSTANT_INTEGER = 3;
    private static final int CONSTANT_FLOAT = 4;
    private static final int CONSTANT_LONG = 5;
    private static final int CONSTANT_DOUBLE = 6;
    private static final int CONSTANT_NAME_AND_TYPE = 12;
    private static final int CONSTANT_UTF8 = 1;
    private static final int CONSTANT_METHOD_HANDLE = 15;
    private static final int CONSTANT_METHOD_TYPE = 16;
    private static final int CONSTANT_INVOKE_DYNAMIC = 18;
    private static final int CONSTANT_MODULE = 19;
    private static final int CONSTANT_PACKAGE = 20;
    private final Constant[] pool;

    public Constant(Constant[] constantArray) {
        this.pool = constantArray;
    }

    public Constant getConstant(int n) {
        return this.pool[n];
    }

    public static Constant[] extractConstantPool(DataInputStream dataInputStream) throws IOException {
        Constant[] constantArray = null;
        if (dataInputStream.readInt() == -889275714) {
            boolean bl;
            dataInputStream.readUnsignedShort();
            dataInputStream.readUnsignedShort();
            int n = dataInputStream.readUnsignedShort();
            constantArray = new Constant[n];
            for (int i = 1; i < n; i += bl ? 2 : 1) {
                bl = false;
                Constant constant = null;
                int n2 = dataInputStream.readUnsignedByte();
                switch (n2) {
                    case 7: {
                        constant = new ClassConstant(constantArray, dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 9: {
                        constant = new FieldRefConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 10: {
                        constant = new MethodRefConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 11: {
                        constant = new InterfaceMethodRefConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 8: {
                        constant = new StringConstant(constantArray, dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 3: {
                        constant = new IntConstant(constantArray, dataInputStream.readInt());
                        break;
                    }
                    case 4: {
                        constant = new FloatConstant(constantArray, dataInputStream.readFloat());
                        break;
                    }
                    case 5: {
                        constant = new LongConstant(constantArray, dataInputStream.readLong());
                        bl = true;
                        break;
                    }
                    case 6: {
                        constant = new DoubleConstant(constantArray, dataInputStream.readDouble());
                        bl = true;
                        break;
                    }
                    case 12: {
                        constant = new NameAndTypeConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 1: {
                        constant = new UTF8Constant(constantArray, dataInputStream.readUTF());
                        break;
                    }
                    case 15: {
                        constant = new MethodHandleConstant(constantArray, dataInputStream.readUnsignedByte(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 16: {
                        constant = new MethodTypeConstant(constantArray, dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 18: {
                        constant = new InvokeDynamicConstant(constantArray, dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 19: {
                        constant = new ModuleConstant(constantArray, dataInputStream.readUnsignedShort());
                        break;
                    }
                    case 20: {
                        constant = new PackageConstant(constantArray, dataInputStream.readUnsignedShort());
                        break;
                    }
                    default: {
                        throw new IOException("Unknown constant pool tag. New Java version (10+) came out?");
                    }
                }
                constantArray[i] = constant;
            }
            return constantArray;
        }
        throw new IOException("Not a class file: Magic number missing.");
    }
}

