/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.classfile.UTF8Constant;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

class ClassNameExtractor {
    private final String constant;
    private int index;
    private int endIndex;
    private final Set<String> classNames = new LinkedHashSet<String>();
    private boolean valid = true;

    ClassNameExtractor(UTF8Constant uTF8Constant) {
        this.constant = uTF8Constant.getString();
        this.endIndex = this.constant.length();
    }

    private boolean endOfTypes() {
        return this.index >= this.endIndex || this.constant.charAt(this.index) == '>';
    }

    Set<String> extract() {
        int n;
        if (this.getCurrentCharacter() == '<') {
            n = this.constant.indexOf("::", this.index);
            if (n > 0) {
                this.index = n + 2;
                this.parseTypes(false);
                if (this.getCurrentCharacter() == '>') {
                    ++this.index;
                } else {
                    this.setInvalid();
                }
            } else {
                this.setInvalid();
            }
        }
        if (this.getCurrentCharacter() == '(') {
            n = this.constant.indexOf(41, this.index);
            if (n > 0) {
                ++this.index;
                this.endIndex = n;
                this.parseTypes(false);
                this.index = n + 1;
                this.endIndex = this.constant.length();
            } else {
                this.setInvalid();
            }
        }
        if (this.valid && (n = this.parseTypes(false)) == 0) {
            this.setInvalid();
        }
        return this.valid ? this.classNames : Collections.emptySet();
    }

    private void extractClassName(int n) {
        String string = this.constant.substring(this.index, n);
        string = string.replace('/', '.');
        this.classNames.add(string);
        this.index = n + 1;
        if (!ClassNameExtractor.isValid(string)) {
            this.setInvalid();
        }
    }

    private char getCurrentCharacter() {
        return this.index < this.endIndex ? this.constant.charAt(this.index) : (char)'\u0000';
    }

    private void parseComplexType() {
        int n = this.constant.indexOf(60, this.index);
        int n2 = this.constant.indexOf(59, this.index);
        if (n >= 0 && n < n2) {
            this.extractClassName(n);
            this.parseTypes(true);
            this.index += 2;
        } else if (n2 > 0) {
            this.extractClassName(n2);
        } else {
            this.setInvalid();
        }
    }

    private void parseType(boolean bl) {
        char c;
        if (bl) {
            c = this.getCurrentCharacter();
            if (c == '+') {
                ++this.index;
            } else if (c == '*') {
                ++this.index;
                return;
            }
        }
        c = '\u0000';
        while (this.getCurrentCharacter() == '[') {
            c = '\u0001';
            ++this.index;
        }
        if (c != '\u0000' && this.endOfTypes()) {
            this.setInvalid();
        } else {
            char c2 = this.getCurrentCharacter();
            ++this.index;
            if (c2 == 'L') {
                this.parseComplexType();
            } else if (c2 == 'T') {
                int n = this.constant.indexOf(59, this.index);
                if (n < 0) {
                    this.setInvalid();
                } else {
                    this.index = n + 1;
                }
            } else if ("BCDFIJSVZ".indexOf(c2) < 0) {
                this.setInvalid();
            }
        }
    }

    private int parseTypes(boolean bl) {
        int n = 0;
        while (this.valid && !this.endOfTypes()) {
            this.parseType(bl);
            ++n;
        }
        return n;
    }

    private void setInvalid() {
        this.valid = false;
    }

    static boolean isValid(String string) {
        boolean bl = true;
        boolean bl2 = true;
        int n = string.length();
        for (int i = 0; bl && i < n; ++i) {
            char c = string.charAt(i);
            if (bl2) {
                bl2 = false;
                bl = Character.isJavaIdentifierStart(c);
                continue;
            }
            if (c == '.') {
                bl2 = true;
                continue;
            }
            bl = Character.isJavaIdentifierPart(c);
        }
        return bl && !bl2;
    }
}

