/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.NameAndSourceAttributes;

public class ClassAttributes
extends NameAndSourceAttributes {
    public static final String INTERFACE = "interface";
    public static final String ABSTRACT_CLASS = "abstract class";
    public static final String CLASS = "class";
    public static final String UNKNOWN = "unknown external class";
    private final String type;
    private final boolean innerClass;
    private final int size;

    public ClassAttributes(String string, String string2, String string3, int n) {
        super(string);
        if (string2 != null) {
            this.addSource(string2);
        }
        this.type = string3;
        this.innerClass = string != null && string.indexOf(36) > 0;
        this.size = n;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public String getType() {
        return this.type;
    }

    public boolean isInnerClass() {
        return this.innerClass;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder(this.innerClass ? "inner " : "");
        stringBuilder.append(this.type).append(' ').append(this.getName());
        if (this.size > 0) {
            stringBuilder.append(" (").append(this.size).append(" bytes)");
        }
        if ((string = this.getSources()).length() > 0) {
            stringBuilder.append(" sources: ").append(string);
        }
        return stringBuilder.toString();
    }

    public static ClassAttributes createAbstractClass(String string, String string2, int n) {
        return new ClassAttributes(string, string2, ABSTRACT_CLASS, n);
    }

    public static ClassAttributes createClass(String string, String string2, int n) {
        return new ClassAttributes(string, string2, CLASS, n);
    }

    public static ClassAttributes createInterface(String string, String string2, int n) {
        return new ClassAttributes(string, string2, INTERFACE, n);
    }

    public static ClassAttributes createUnknownClass(String string, int n) {
        return new ClassAttributes(string, null, UNKNOWN, n);
    }
}

