/*
 * Decompiled with CFR 0.152.
 */
package classycle;

import classycle.CommandLine;

public class AnalyserCommandLine
extends CommandLine {
    private static final String XML_FILE = "-xmlFile=";
    private static final String CSV_FILE = "-csvFile=";
    private static final String TITLE = "-title=";
    private boolean packagesOnly;
    private boolean raw;
    private boolean cycles;
    private boolean strong;
    private String title;
    private String xmlFile;
    private String csvFile;

    public AnalyserCommandLine(String[] stringArray) {
        super(stringArray);
        if (this.title == null && this.classFiles.length > 0) {
            this.title = this.classFiles[0];
        }
    }

    public String getCsvFile() {
        return this.csvFile;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getUsage() {
        return "[-raw] [-packagesOnly] [-cycles|-strong] [-xmlFile=<file>] [-csvFile=<file>] [-title=<title>] " + super.getUsage();
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    @Override
    protected void handleOption(String string) {
        if (string.equals("-raw")) {
            this.raw = true;
        } else if (string.equals("-packagesOnly")) {
            this.packagesOnly = true;
        } else if (string.equals("-cycles")) {
            this.cycles = true;
        } else if (string.equals("-strong")) {
            this.strong = true;
        } else if (string.startsWith(TITLE)) {
            this.title = string.substring(TITLE.length());
            if (this.title.length() == 0) {
                this.valid = false;
            }
        } else if (string.startsWith(XML_FILE)) {
            this.xmlFile = string.substring(XML_FILE.length());
            if (this.xmlFile.length() == 0) {
                this.valid = false;
            }
        } else if (string.startsWith(CSV_FILE)) {
            this.csvFile = string.substring(CSV_FILE.length());
            if (this.csvFile.length() == 0) {
                this.valid = false;
            }
        } else {
            super.handleOption(string);
        }
    }

    public boolean isCycles() {
        return this.cycles;
    }

    public boolean isPackagesOnly() {
        return this.packagesOnly;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public boolean isStrong() {
        return this.strong;
    }
}

