/*
 * Decompiled with CFR 0.152.
 */
package ba.jamax.util.rest.controller;

import ba.jamax.util.rest.model.Filter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"nd", "$edit", "$newRow"})
public class RequestGridViewModel
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(RequestGridViewModel.class);
    private static final long serialVersionUID = 5679777077467867776L;
    private Filter filter;
    @JsonIgnore
    private final ObjectMapper mapper = new ObjectMapper();
    private Map<String, Object> criteria = new HashMap<String, Object>();
    private boolean search;
    private int page;
    private int rows;
    private String order;
    private String sort;
    private String filters;
    private String searchField;
    private String searchOper;
    private String searchString;

    public String toString() {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("RequestGridViewModel [");
        if (this.criteria != null) {
            builder.append("criteria=").append(this.toString(this.criteria.entrySet(), 10)).append(", ");
        }
        builder.append("search=").append(this.search).append(", page=").append(this.page).append(", rows=").append(this.rows).append(", ");
        if (this.order != null) {
            builder.append("order=").append(this.order).append(", ");
        }
        if (this.sort != null) {
            builder.append("sort=").append(this.sort).append(", ");
        }
        if (this.filters != null) {
            builder.append("filters=").append(this.filters).append(", ");
        }
        if (this.searchField != null) {
            builder.append("searchField=").append(this.searchField).append(", ");
        }
        if (this.searchOper != null) {
            builder.append("searchOper=").append(this.searchOper).append(", ");
        }
        if (this.searchString != null) {
            builder.append("searchString=").append(this.searchString).append(", ");
        }
        if (this.filter != null) {
            builder.append("filter=").append(this.filter);
        }
        builder.append("]");
        return builder.toString();
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    private void addFiltersToCriteria(String filters) {
        if (filters != null && !filters.isEmpty()) {
            try {
                this.filter = (Filter)this.mapper.readValue(filters, Filter.class);
            }
            catch (JsonParseException e) {
                logger.error("Could not parse json data", (Throwable)e);
            }
            catch (JsonMappingException e) {
                logger.error("Could not map json data", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Input-output error", (Throwable)e);
            }
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getFilters() {
        return this.filters;
    }

    public void setFilters(String filters) {
        this.filters = filters;
        this.addFiltersToCriteria(filters);
    }

    public Map<String, Object> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(Map<String, Object> criteria) {
        this.criteria = criteria;
    }

    public boolean getSearch() {
        return this.search;
    }

    public void setSearch(boolean search) {
        this.search = search;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getSearchField() {
        return this.searchField;
    }

    public void setSearchField(String searchField) {
        this.searchField = searchField;
    }

    public String getSearchOper() {
        return this.searchOper;
    }

    public void setSearchOper(String searchOper) {
        this.searchOper = searchOper;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }
}

