/*
 * Decompiled with CFR 0.152.
 */
package ba.jamax.util.rest.dao;

import ba.jamax.util.rest.dao.GenericDAO;
import ba.jamax.util.rest.model.BaseEntity;
import ba.jamax.util.rest.model.Filter;
import ba.jamax.util.rest.model.FilterRule;
import ba.jamax.util.rest.model.Rule;
import ba.jamax.util.rest.service.GenericServiceImpl;
import ba.jamax.util.rest.util.GenericUtils;
import ba.jamax.util.rest.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class GenericDAOImpl<T extends BaseEntity>
implements GenericDAO<T> {
    private final Logger logger = LoggerFactory.getLogger(GenericServiceImpl.class);
    private static final String UNKNOWN = "Unknown";
    private final Map<String, String> aliasMap = new HashMap<String, String>();
    @Autowired
    private SessionFactory sessionFactory;
    private Class<T> entityClass;
    private GenericUtils<T> utils = new GenericUtils();
    private TypeUtils typeUtils = new TypeUtils();

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public GenericDAOImpl() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.entityClass = (Class)genericSuperclass.getActualTypeArguments()[0];
    }

    @Autowired
    public void init(SessionFactory factory) {
        this.setSessionFactory(factory);
    }

    @Override
    public T findById(Serializable id) {
        return (T)((BaseEntity)this.getSessionFactory().getCurrentSession().get(this.entityClass, id));
    }

    @Override
    public T addNew(T t) {
        ((BaseEntity)t).setCreated(new Date());
        ((BaseEntity)t).setCreatedBy(this.getUsernameInSession());
        this.getSessionFactory().getCurrentSession().saveOrUpdate(t);
        return t;
    }

    @Override
    public Collection<T> addAll(Collection<T> tList) {
        Date currentDate = new Date();
        String currentUser = this.getUsernameInSession();
        for (BaseEntity t : tList) {
            t.setCreated(currentDate);
            t.setCreatedBy(currentUser);
            this.getSessionFactory().getCurrentSession().saveOrUpdate((Object)t);
        }
        return tList;
    }

    @Override
    public void delete(T t) {
        this.getSessionFactory().getCurrentSession().delete(t);
    }

    @Override
    public void update(T t) {
        ((BaseEntity)t).setModified(new Date());
        ((BaseEntity)t).setModifiedBy(this.getUsernameInSession());
        this.getSessionFactory().getCurrentSession().update(t);
    }

    @Override
    public List<T> findByCriteria(Map<String, Object> criterias, Filter filter, boolean strict, int firstResult, int maxResults, Order order) {
        Criteria criteria = this.getSessionFactory().getCurrentSession().createCriteria(this.entityClass);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.setFirstResult(firstResult);
        criteria.setMaxResults(maxResults);
        criteria = this.createCriteria(criterias, filter, strict, criteria, order);
        return criteria.list();
    }

    @Override
    public int countByCriteria(Map<String, Object> criteriaMap, Filter filter, boolean strict) {
        Criteria criteria = this.getSessionFactory().getCurrentSession().createCriteria(this.entityClass);
        this.createCriteria(criteriaMap, filter, strict, criteria, null);
        criteria.setProjection(Projections.rowCount());
        return criteria.list().size() > 0 ? ((Number)criteria.list().get(0)).intValue() : 0;
    }

    private void addAliasesToCriteria(String key, Criteria criteria) {
        if (key != null && key.contains(".")) {
            if (key.contains(",")) {
                String[] keys;
                for (String k : keys = key.split(",")) {
                    this.addAliasesToCriteria(k, criteria);
                }
            } else {
                String[] entities = key.split("\\.");
                if (entities != null && entities.length > 1) {
                    this.createAlias(entities[0], entities[0], criteria);
                    this.createAliasesRecursive(criteria, entities, 0);
                }
            }
        }
    }

    private void createAliasesRecursive(Criteria criteria, String[] entities, int counter) {
        if (counter + 2 >= entities.length) {
            return;
        }
        this.createAlias(entities[++counter] + "." + entities[counter + 1], entities[counter + 1], criteria);
        this.createAliasesRecursive(criteria, entities, counter);
    }

    private void createAlias(String key, String value, Criteria criteria) {
        String aValue = this.aliasMap.get(key);
        if (aValue == null) {
            criteria.createAlias(key, value);
            this.aliasMap.put(key, value);
        }
    }

    private void addRestrictionsToCriteria(Map<String, Object> criterias, boolean strict, Criteria criteria) {
        for (Map.Entry<String, Object> entry : criterias.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            this.addAliasesToCriteria(key, criteria);
            if (value instanceof String) {
                if (strict) {
                    criteria.add((Criterion)Restrictions.eq((String)key, (Object)value));
                    continue;
                }
                criteria.add(Restrictions.ilike((String)key, (String)((String)value), (MatchMode)MatchMode.ANYWHERE));
                continue;
            }
            criteria.add((Criterion)Restrictions.eq((String)key, (Object)value));
        }
    }

    private Criteria createCriteria(Map<String, Object> criterias, Filter filter, boolean strict, Criteria criteria, Order order) {
        this.aliasMap.clear();
        if (order != null) {
            this.addAliasesToCriteria(order.getPropertyName(), criteria);
        }
        this.addRestrictionsToCriteria(criterias, strict, criteria);
        this.addFiltersToCriteria(filter, criteria);
        if (order != null) {
            if (order.getPropertyName().contains(",")) {
                String[] keys;
                for (String k : keys = order.getPropertyName().split(",")) {
                    criteria.addOrder(Order.asc((String)k.trim()));
                }
            } else {
                criteria.addOrder(order);
            }
        }
        return criteria;
    }

    private void addFiltersToCriteria(Filter filter, Criteria criteria) {
        if (filter != null) {
            List<? extends FilterRule> rules = filter.getRules();
            String groupOp = filter.getGroupOp();
            Criterion criterion = null;
            Serializable dataObj = null;
            for (FilterRule filterRule : rules) {
                try {
                    if (filterRule instanceof Rule) {
                        Rule rule = (Rule)filterRule;
                        String data = rule.getData();
                        String field = rule.getField();
                        Method m = this.utils.getGetter(this.entityClass, field);
                        dataObj = this.typeUtils.getCorrectObjectType(m, (Serializable)((Object)data));
                        if (criterion == null) {
                            criterion = this.decodeOp(rule.getOp(), field, dataObj);
                            continue;
                        }
                        if (groupOp.equals("AND")) {
                            criterion = Restrictions.and((Criterion)criterion, (Criterion)this.decodeOp(rule.getOp(), field, dataObj));
                            continue;
                        }
                        if (!groupOp.equals("OR")) continue;
                        criterion = Restrictions.or((Criterion)criterion, (Criterion)this.decodeOp(rule.getOp(), field, dataObj));
                        continue;
                    }
                    if (!(filterRule instanceof Filter)) continue;
                    Filter filter2 = (Filter)filterRule;
                    this.addFiltersToCriteria(filter2, criteria);
                }
                catch (Exception e) {
                    this.logger.error("Could not create criterion", (Throwable)e);
                }
            }
            if (criterion != null) {
                criteria.add(criterion);
            }
        }
    }

    protected String getUsernameInSession() {
        String username = UNKNOWN;
        try {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            username = auth.getName();
        }
        catch (Exception e) {
            this.logger.info("Could not get username");
        }
        return username;
    }

    private Criterion decodeOp(String op, String propertyName, Object value) throws Exception {
        if (op.equals("eq")) {
            return Restrictions.eq((String)propertyName, (Object)value);
        }
        if (op.equals("ne")) {
            return Restrictions.ne((String)propertyName, (Object)value);
        }
        if (op.equals("lt")) {
            return Restrictions.lt((String)propertyName, (Object)value);
        }
        if (op.equals("le")) {
            return Restrictions.le((String)propertyName, (Object)value);
        }
        if (op.equals("gt")) {
            return Restrictions.gt((String)propertyName, (Object)value);
        }
        if (op.equals("ge")) {
            return Restrictions.ge((String)propertyName, (Object)value);
        }
        if (op.equals("bw")) {
            return Restrictions.ilike((String)propertyName, (String)value.toString(), (MatchMode)MatchMode.START);
        }
        if (op.equals("bn")) {
            return Restrictions.not((Criterion)Restrictions.ilike((String)propertyName, (String)value.toString(), (MatchMode)MatchMode.START));
        }
        if (op.equals("in")) {
            return Restrictions.in((String)propertyName, (Object[])value.toString().split(" "));
        }
        if (op.equals("ni")) {
            return Restrictions.not((Criterion)Restrictions.in((String)propertyName, (Object[])value.toString().split(" ")));
        }
        if (op.equals("ew")) {
            return Restrictions.ilike((String)propertyName, (String)value.toString(), (MatchMode)MatchMode.END);
        }
        if (op.equals("en")) {
            return Restrictions.not((Criterion)Restrictions.ilike((String)propertyName, (String)value.toString(), (MatchMode)MatchMode.END));
        }
        if (op.equals("cn")) {
            return Restrictions.ilike((String)propertyName, (String)value.toString(), (MatchMode)MatchMode.ANYWHERE);
        }
        if (op.equals("nc")) {
            return Restrictions.not((Criterion)Restrictions.ilike((String)propertyName, (String)value.toString(), (MatchMode)MatchMode.ANYWHERE));
        }
        if (op.equals("nu")) {
            return Restrictions.isNull((String)propertyName);
        }
        if (op.equals("nn")) {
            return Restrictions.isNotNull((String)propertyName);
        }
        throw new Exception("Unknown op: \"" + op + "\"");
    }
}

