/*
 * Decompiled with CFR 0.152.
 */
package ba.jamax.util.rest.controller;

import ba.jamax.util.rest.controller.AbstractRestController;
import ba.jamax.util.rest.controller.RequestGridViewModel;
import ba.jamax.util.rest.controller.ResponseGridViewModel;
import ba.jamax.util.rest.model.BaseEntity;
import ba.jamax.util.rest.service.GenericService;
import ba.jamax.util.rest.util.GenericUtils;
import ba.jamax.util.rest.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Order;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.LocaleResolver;

public abstract class AbstractRestControllerImpl<T extends BaseEntity>
implements AbstractRestController<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRestControllerImpl.class);
    @Autowired
    private ApplicationContext context;
    @Autowired
    private LocaleResolver localeResolver;
    private GenericService<T> service;
    private GenericUtils<T> genericUtils = new GenericUtils();
    private TypeUtils typeUtils = new TypeUtils();

    protected abstract Class<T> getPersistentClass();

    public GenericService<T> getService() {
        return this.service;
    }

    public void setService(GenericService<T> service) {
        this.service = service;
    }

    public ApplicationContext getContext() {
        return this.context;
    }

    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    @Override
    @RequestMapping(value={"/index"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseGridViewModel<T> index(@RequestBody RequestGridViewModel gridViewModel, HttpServletRequest request) {
        LOGGER.debug("gridViewModel[{}]", new Object[]{gridViewModel});
        this.prepareGridViewModel(gridViewModel, request);
        return this.getFilteredEntity(gridViewModel);
    }

    @Override
    @RequestMapping(value={"/insert"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, ? extends Object> doInsert(@RequestBody T t, HttpServletRequest request) {
        LOGGER.debug("t[{}]", new Object[]{t});
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        try {
            this.getService().addNew(t);
            responseMap.put("object", t);
        }
        catch (Exception e) {
            String localizedMessage = this.context.getMessage("General.list.message.error.add.failed", null, this.localeResolver.resolveLocale(request));
            responseMap.put("error", new String[]{localizedMessage});
        }
        return responseMap;
    }

    @Override
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, ? extends Object> doUpdate(@RequestBody T t, HttpServletRequest request) {
        LOGGER.debug("t[{}]", new Object[]{t});
        HashMap<String, String[]> responseMap = new HashMap<String, String[]>();
        try {
            this.getService().update(t);
        }
        catch (Exception e) {
            String localizedMessage = this.context.getMessage("General.list.message.error.update.failed", null, this.localeResolver.resolveLocale(request));
            responseMap.put("error", new String[]{localizedMessage});
        }
        return responseMap;
    }

    @Override
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, ? extends Object> doDelete(@RequestParam(value="id") Serializable entityId, HttpServletRequest request) {
        LOGGER.debug("entityId[{}]", new Object[]{entityId});
        HashMap<String, String[]> responseMap = new HashMap<String, String[]>();
        try {
            T t = this.getService().findById(this.typeUtils.getCorrectObjectType(this.getGetterMethod("id"), entityId));
            if (t != null) {
                this.getService().delete(t);
            }
        }
        catch (Exception e) {
            String localizedMessage = this.context.getMessage("General.list.message.error.delete.failed", null, this.localeResolver.resolveLocale(request));
            responseMap.put("error", new String[]{localizedMessage});
        }
        return responseMap;
    }

    @Override
    @RequestMapping(value={"/updatePreferedGridRowNum"}, method={RequestMethod.POST})
    @ResponseBody
    public String updatePreferedGridRowNum(@RequestParam Integer newRowNum, HttpServletRequest request) {
        LOGGER.debug("newRowNum[{}]", new Object[]{newRowNum});
        HttpSession session = request.getSession();
        session.setAttribute("gridRowNum", (Object)newRowNum);
        return null;
    }

    public ResponseGridViewModel<T> getFilteredEntity(RequestGridViewModel gridViewModel) {
        Map<String, Object> criteriaMap = gridViewModel.getCriteria();
        int page = gridViewModel.getPage();
        int rows = gridViewModel.getRows();
        if (gridViewModel.getSearch() && !gridViewModel.getCriteria().isEmpty()) {
            criteriaMap.putAll(gridViewModel.getCriteria());
        }
        String sort = StringUtils.isEmpty((String)gridViewModel.getSort()) ? "id" : gridViewModel.getSort();
        Order order = "desc".equals(gridViewModel.getOrder()) ? Order.desc((String)sort) : Order.asc((String)sort);
        List<T> records = this.getService().findByCriteria(criteriaMap, gridViewModel.getFilter(), false, (page - 1) * rows, rows, order);
        int totalRecords = this.getService().countByCriteria(criteriaMap, gridViewModel.getFilter(), false);
        int totalPages = totalRecords / rows;
        if (totalRecords % rows > 0) {
            ++totalPages;
        }
        ResponseGridViewModel<T> model = new ResponseGridViewModel<T>(records, page, totalPages, totalRecords);
        return model;
    }

    protected void prepareGridViewModel(RequestGridViewModel gridViewModel, HttpServletRequest request) {
        if (!gridViewModel.getCriteria().isEmpty()) {
            HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
            for (String key : gridViewModel.getCriteria().keySet()) {
                Object value = gridViewModel.getCriteria().get(key);
                value = this.typeUtils.getCorrectObjectType(this.getGetterMethod(key), (Serializable)value);
                criteriaMap.put(key, value);
            }
            gridViewModel.setCriteria(criteriaMap);
        }
    }

    protected Method getGetterMethod(String key) {
        String[] entities;
        Method m = this.genericUtils.getGetter(this.getPersistentClass(), key);
        if (key != null && key.contains(".") && (entities = key.split("\\.")) != null && entities.length > 1) {
            m = this.getChainedGetterMethod(this.getPersistentClass(), entities, 0);
        }
        return m;
    }

    protected Method getChainedGetterMethod(Class type, String[] entities, int counter) {
        Method method = this.genericUtils.getGetter(type, entities[counter]);
        if (++counter >= entities.length) {
            return method;
        }
        return this.getChainedGetterMethod(method.getReturnType(), entities, counter);
    }
}

